app
	.component('appVentas', {
		templateUrl: './views/ventas/ventas.view.html',
		controller: CtrlVentas
	});

CtrlVentas.$inject = ['$scope', 'api.service', 'form.service', 'alert.service'];



function CtrlVentas(scope, api, form, alert) {

	scope.ventas = [];
	scope.formapago=[];

	Init = () => {
		scope.spinner = true;

		api.list('ventas/lista').then(res => {
			scope.ventas = res.data;
		})

		api.list('ventas/parametros').then(res => {
			scope.formapago = res.data.formapago;
		})


		.finally(fin => scope.spinner = false);
	}


	scope.openModal = (index, object = {}) => {
		Clean();

		switch (index) {
			case 1:
				scope.modal.edit = true;
				scope.modal.title = "Registrar Pago";
				scope.modal.model = angular.copy(object);
				form.modal('edit');
			break;

			case 2:
			
				scope.modal.spinnertwo = true;

				api.list('ventas/lista').then(res => {
					scope.ventas = res.data;
				})
					.finally(fin => scope.modal.spinnertwo = false);
				scope.modal.title = "Sincronizar SUNAT - VENTAS";
				form.modal('editsinsunat');
			break;


		}
	}

	scope.savesinsunat = () => {
		scope.modal.spinner = true;
		scope.modal.fails = {};
		let promise;

		promise = api.list('ventas/getfact');
		promise.then(res => Process(res)).catch(error => ManagerError(error)).finally(fin => scope.modal.spinner = false);

	}

	scope.printVenta = (venta_id) => {
		const name = 'venta_' + venta_id;
		const params = {
			id: venta_id
		};
		api.downloadPDF('rendicion/imprimir', name, params);
	}

	scope.cbxformapago = (idforma) => {
		//modal.model.id_formapagoconsole.log("v:"+idforma)
		if (idforma >= 1){
			scope.modal.model.editforma = 1;
		}else{
			scope.modal.model.editforma = 0;
		}
		
		
	}

	scope.save = () => {
		scope.modal.spinner = true;
		scope.modal.fails = {};

		let promise;
		
		const data = {
			id: scope.modal.model.id,
			id_formapago: scope.modal.model.id_formapago,
			fechapago: formatDate(scope.modal.model.fechapago),
			montopago: scope.modal.model.montopago,
			detallepago: scope.modal.model.detallepago
		}
		
		promise = api.update('ventas', data);
		promise.then(res => Process(res)).catch(error => ManagerError(error)).finally(fin => scope.modal.spinner = false);
	

	}

	scope.delete = (ventas) => 
		{
			scope.deleted = ventas;
			alert.confirm("¡Se eliminara el pago registrado en la factura " +  ventas.serie+ '-' + ventas.numero+ " ,esta operación es irreversible!",Delete);		
		}
	
	Delete = (ventas) => 
	{
		
		scope.spinner_delete = true;

		api.delete('ventas',scope.deleted.id).then(res => {
			if(!res.data.success) return ManagerError(res.data.message);
			alert.success(res.data.message);
			Init();
		})
		.catch(error => ManagerError(error))
		.finally(fin => scope.spinner_delete = false);
	}
	
	Process = (res) => {
		if (res.data.fails)
			return scope.modal.fails = res.data.fails;

		if (!res.data.success)
			return alert.warning(res.data.message);

		alert.success(res.data.message);
		form.modal('edit', false);
		form.modal('editsinsunat', false);
		Init();
	}

	ManagerError = (error) => {
		alert.warning(error);
	}

	Clean = () => {
		scope.modal = { model: {}, fails: {} };
	}

	Init();
}

function formatDate(date) {
	var d = new Date(date),
		month = '' + (d.getMonth() + 1),
		day = '' + d.getDate(),
		year = d.getFullYear();

	if (month.length < 2) 
		month = '0' + month;
	if (day.length < 2) 
		day = '0' + day;

	return [year, month, day].join('-');
}
