app
	.component('appVentaconsulta', {
		templateUrl: './views/ventaconsulta/ventaconsulta.view.html',
		controller: CtrlVentaconsulta
	});

CtrlVentaconsulta.$inject = ['$scope', 'api.service', 'form.service', 'alert.service'];


function CtrlVentaconsulta(scope, api, form, alert) {
	
	scope.ventas = [];
	

	Init = () => {
		form.modal('edit', false);
		scope.spinner = true;

		api.list('ventaconsulta/lista').then(res => {
			scope.ventas = res.data;
		})

		.finally(fin => scope.spinner = false);
	}

	scope.openModal = (index, object = {}) => {
		Clean();

		switch (index) {
			case 1:
				scope.modal.edit = true;
				scope.modal.title = "Detalle Venta";
				scope.modal.model = angular.copy(object);
				form.modal('edit');
			break;
		}
	}

	scope.deletepago = (ventas) => 
		{
			scope.deleted = ventas;
			alert.confirm("¡Se eliminara el pago registrado en la factura " +  ventas.serie+ '-' + ventas.numero+ " ,esta operación es irreversible!",Deletepago);		
		}
	
	Deletepago = (ventas) => 
	{
		
		scope.spinner_delete = true;

		api.delete('ventas',scope.deleted.id).then(res => {
			if(!res.data.success) return ManagerError(res.data.message);
			alert.success(res.data.message);
			Init();
		})
		.catch(error => ManagerError(error))
		.finally(fin => scope.spinner_delete = false);
	}
	
	scope.deletedetraccion = (detraccion) => 
		{
			scope.deleted = detraccion;
			alert.confirm("¡Se eliminara la detracción " +  detraccion.iddetraccion+ " ,esta operación es irreversible!",Deletedetraccion);		
		}
	
	Deletedetraccion = (detraccion) => 
	{
		
		scope.spinner_delete = true;

		
		api.delete('detraccion',scope.deleted.id).then(res => {
			if(!res.data.success) return ManagerError(res.data.message);
			alert.success(res.data.message);
			Init();
		})
		.catch(error => ManagerError(error))
		.finally(fin => scope.spinner_delete = false);
		
	}

	scope.deletebajafact = (fact) => 
		{
			scope.deleted = fact;
			alert.confirm("¡Se dara de baja a la factura: " +  fact.serie+'-'+fact.numero + " ,esta operación es irreversible!",Deletebajafact);		
		}
	
	Deletebajafact = (fact) => 
	{
		
		scope.spinner_delete = true;

		
		api.delete('ventaconsulta',scope.deleted.id).then(res => {
			if(!res.data.success) return ManagerError(res.data.message);
			alert.success(res.data.message);
			Init();
		})
		.catch(error => ManagerError(error))
		.finally(fin => scope.spinner_delete = false);
		
	}
	

	Process = (res) => {
		if (res.data.fails)
			return scope.modal.fails = res.data.fails;

		if (!res.data.success)
			return alert.warning(res.data.message);

		alert.success(res.data.message);
		form.modal('edit', false);
		Init();
	}

	ManagerError = (error) => {
		alert.warning(error);
	}

	Clean = () => {
		scope.modal = { model: {}, fails: {} };
	}

	Init();
}

