app
	.component('appVehiculos',{
		templateUrl: './views/vehiculos/vehiculos.view.html',
		controller: CtrlVehiculos
	});

	CtrlVehiculos.$inject = ['$scope','api.service','form.service','alert.service'];

	function CtrlVehiculos(scope,api,form,alert) 
	{
		Init = () => 
		{
			scope.spinner = true;
			Paises();
			Vehiculos();
		}

		Paises = () => 
		{
			api.list('pais').then(res => scope.paises = res.data.paises);
		}

		Vehiculos = () => 
		{
			scope.spinner = true;
			api.list('vehiculo').then(res => {
				scope.vehiculos = res.data.vehiculos;
			})
			.finally(fin => scope.spinner = false);
		}

		scope.openModal = (index,object = {}) => 
		{
			Clean();

			switch(index)
			{
				case 1:
					scope.modal.edit = false;
					scope.modal.title = "Agregar Vehiculo";
					form.modal('edit');
				break;
				case 2:
					scope.modal.edit = true;
					scope.modal.title = "Editar Vehiculo";
					scope.modal.model = angular.copy(object);
					form.modal('edit');
				break;
			}
		}

		scope.save = () => 
		{
			scope.modal.spinner = true;
			scope.modal.fails   = {};

			let promise;

			if(scope.modal.model.id){
				promise = api.update('vehiculo',scope.modal.model);
			}else{
				promise = api.store('vehiculo',scope.modal.model);
			}

			promise.then(res => Process(res)).catch(error => ManagerError(error)).finally(fin => scope.modal.spinner = false);
		}

		scope.delete = (vehiculo) => 
		{
			scope.deleted = vehiculo;
			alert.confirm("¡Se eliminara el vehiculo con placa " + vehiculo.placa + " de la lista de vehiculos, esta operación es irreversible!",Delete);
		}

		Delete = (vehiculo) => 
		{
			scope.spinner_delete = true;

			api.delete('vehiculo',scope.deleted.id).then(res => {
				if(!res.data.success) return ManagerError(res.data.message);
				alert.success(res.data.message);
				Vehiculos();
			})
			.catch(error => ManagerError(error))
			.finally(fin => scope.spinner_delete = false);
		}

		Process = (res) => 
		{
			if(res.data.fails)
				return scope.modal.fails = res.data.fails;

			if(!res.data.success)
				return alert.warning(res.data.message);
			
			alert.success(res.data.message);
			form.modal('edit',false);
			Vehiculos();
		}

		ManagerError = (error) => {
			alert.warning(error);
		}

		Clean = () => {
			scope.modal = {model: {},fails: {}};
		}

		Init();
	}