app
	.component('appUsuariosApp',{
		templateUrl: './views/usuarios_app/usuarios_app.view.html',
		controller: CtrlUsuariosApp
	});

	CtrlUsuariosApp.$inject = ['$scope','api.service','form.service','alert.service'];

	//let selected;

	function CtrlUsuariosApp(scope,api,form,alert) 
	{
		scope.vehiculos = [];
		scope.choferes = [];
		scope.remolques = [];
		scope.usuarios_app = [];

		Init = () => 
		{
			scope.spinner = true;

			api.list('usuario_app/parametros').then(res => {
				scope.vehiculos = res.data.vehiculos;
				scope.choferes = res.data.choferes;
				scope.remolques = res.data.remolques;
			})

			api.list('usuario_app/lista').then(res => {
				scope.usuarios_app = res.data;
			})
			.finally(fin => scope.spinner = false);
		}

		scope.openModal = (index,object = {}) => 
		{
			Clean();

			switch(index)
			{
				case 1:
					scope.modal.edit = false;
					scope.modal.title = "Agregar Usuario App";
					form.modal('edit');
				break;
				case 2:
					scope.modal.edit = true;
					scope.modal.title = "Editar Usuario App";
					scope.modal.model = angular.copy(object);
					form.modal('edit');
				break;
			}
		}

		scope.save = () => 
		{
			scope.modal.spinner = true;
			scope.modal.fails   = {};

			let promise;

			//scope.modal.model.username = selected;
			//scope.modal.model.nivel = "C";
			//Primer nombre
			//var cbx_nom = document.getElementById("cbx_chof");
			//var text_select = cbx_nom.options[cbx_nom.selectedIndex].text;
			//var nombreextraido = text_select.split(' ')[0];
			//scope.modal.model.pnombre =nombreextraido;
			//console.log(scope.modal.model);
			//'username','password','pnombre','nivel','id_chofer','id_vehiculo','id_remolque','enabled'

			//Transformacion 
			var combo = document.getElementById("cbx_veh");
			selectedVeh = combo.options[combo.selectedIndex].text;

			//Primer nombre
			var cbx_nom = document.getElementById("cbx_chof");
			var text_select = cbx_nom.options[cbx_nom.selectedIndex].text;
			var nombreextraido = text_select.split(' ')[0];



			const data = {
				username: selectedVeh,
				password: scope.modal.model.password,
				pnombre: nombreextraido,
				nivel: 'C',
				id_chofer: scope.modal.model.id_chofer,
				id_vehiculo: scope.modal.model.id_vehiculo,
				id_remolque: scope.modal.model.id_remolque,
				enabled:scope.modal.model.enabled
			}

			
			if(scope.modal.model.id_usuario){
				//Function_cp();
				data.id = scope.modal.model.id_usuario // Para poder setear el ID que usa el servicio "id"
				promise = api.update('usuario_app',data);
			}else{
				promise = api.store('usuario_app',data);
			}

			promise.then(res => Process(res)).catch(error => ManagerError(error)).finally(fin => scope.modal.spinner = false);
		}

		scope.delete = (usuario_app) => 
		{
			scope.deleted = usuario_app;
			alert.confirm("¡Se eliminara a " + usuario_app.pnombre + " de la lista de usuarios, esta operación es irreversible!",Delete);
		}

		Delete = (usuario_app) => 
		{
			scope.spinner_delete = true;

			api.delete('usuario_app',scope.deleted.id_usuario).then(res => {
				if(!res.data.success) return ManagerError(res.data.message);
				alert.success(res.data.message);
				Init();
			})
			.catch(error => ManagerError(error))
			.finally(fin => scope.spinner_delete = false);
		}

		Process = (res) => 
		{
			if(res.data.fails)
				return scope.modal.fails = res.data.fails;

			if(!res.data.success)
				return alert.warning(res.data.message);
			
			alert.success(res.data.message);
			form.modal('edit',false);
			Init();
		}

		ManagerError = (error) => {
			alert.warning(error);
		}

		Clean = () => {
			scope.modal = {model: {},fails: {}};
		}

		Init();
	}

	/*
	function Function_cp(){

		document.getElementById('usernamedcc').value=null; 
		var combo = document.getElementById("cbx_veh");
		selected = combo.options[combo.selectedIndex].text;
		document.getElementById('usernamedcc').value=selected;
		//alert('holi');

	}
	*/