app
	.component('appTgastos',{
		templateUrl: './views/tgastos/tgastos.view.html',
		controller: CtrlTgastos
	});

	CtrlTgastos.$inject = ['$scope','api.service','form.service','alert.service'];

	
	function CtrlTgastos(scope,api,form,alert) 
	{
		scope.tgastos = [];

		Init = () => 
		{
			scope.spinner = true;

			api.list('Tgastos/lista').then(res => {
				scope.tgastos = res.data;
			})
			.finally(fin => scope.spinner = false);
		}
		
		
		scope.openModal = (index,object = {}) => 
		{
			Clean();

			switch(index)
			{
				case 1:
					scope.modal.edit = false;
					scope.modal.title = "Agregar tipo de gasto";
					form.modal('edit');
				break;
				case 2:
					scope.modal.edit = true;
					scope.modal.title = "Editar tipo de gasto";
					scope.modal.model = angular.copy(object);
					form.modal('edit');
				break;
			}
		}

		scope.save = () => 
		{
			scope.modal.spinner = true;
			scope.modal.fails   = {};

			let promise;

						
			if(scope.modal.model.id){
				//Function_cp();
				//scope.modal.model.id = scope.modal.model.id_ruta;
				promise = api.update('Tgastos',scope.modal.model);
			}else{
				promise = api.store('Tgastos',scope.modal.model);
			}

			promise.then(res => Process(res)).catch(error => ManagerError(error)).finally(fin => scope.modal.spinner = false);
		}

		scope.delete = (Tgastos) => 
		{
			scope.deleted = Tgastos;
			alert.confirm("¡Se eliminara a " + Tgastos.tipo + " de la lista en el APP, esta operación es irreversible!",Delete);
		}

		Delete = (Tgastos) => 
		{
			scope.spinner_delete = true;

			api.delete('Tgastos',scope.deleted.id).then(res => {
				if(!res.data.success) return ManagerError(res.data.message);
				alert.success(res.data.message);
				Init();
			})
			.catch(error => ManagerError(error))
			.finally(fin => scope.spinner_delete = false);
		}
		

		Process = (res) => 
		{
			if(res.data.fails)
				return scope.modal.fails = res.data.fails;

			if(!res.data.success)
				return alert.warning(res.data.message);
			
			alert.success(res.data.message);
			form.modal('edit',false);
			Init();
		}

		ManagerError = (error) => {
			alert.warning(error);
		}

		Clean = () => {
			scope.modal = {model: {},fails: {}};
		}

		Init();
	}

	