app
	.component('appTcargadoc',{
		templateUrl: './views/tcargadoc/tcargadoc.view.html',
		controller: CtrlTcargadoc
	});

	CtrlTcargadoc.$inject = ['$scope','api.service','form.service','alert.service'];

	
	function CtrlTcargadoc(scope,api,form,alert) 
	{
		scope.tcargadoc = [];

		Init = () => 
		{
			scope.spinner = true;

			api.list('Tcargadoc/lista').then(res => {
				scope.tcargadoc = res.data;
			})
			.finally(fin => scope.spinner = false);
		}
		
		
		scope.openModal = (index,object = {}) => 
		{
			Clean();

			switch(index)
			{
				case 1:
					scope.modal.edit = false;
					scope.modal.title = "Agregar tipo eventos";
					form.modal('edit');
				break;
				case 2:
					scope.modal.edit = true;
					scope.modal.title = "Editar  tipo eventos";
					scope.modal.model = angular.copy(object);
					form.modal('edit');
				break;
			}
		}

		scope.save = () => 
		{
			scope.modal.spinner = true;
			scope.modal.fails   = {};

			let promise;

						
			if(scope.modal.model.id){
				//Function_cp();
				//scope.modal.model.id = scope.modal.model.id_ruta;
				promise = api.update('Tcargadoc',scope.modal.model);
			}else{
				promise = api.store('Tcargadoc',scope.modal.model);
			}

			promise.then(res => Process(res)).catch(error => ManagerError(error)).finally(fin => scope.modal.spinner = false);
		}

		scope.delete = (Tcargadoc) => 
		{
			scope.deleted = Tcargadoc;
			alert.confirm("¡Se eliminara a " + Tcargadoc.tipo + " de la lista en el APP, esta operación es irreversible!",Delete);
		}

		Delete = (Tcargadoc) => 
		{
			scope.spinner_delete = true;

			api.delete('Tcargadoc',scope.deleted.id).then(res => {
				if(!res.data.success) return ManagerError(res.data.message);
				alert.success(res.data.message);
				Init();
			})
			.catch(error => ManagerError(error))
			.finally(fin => scope.spinner_delete = false);
		}
		

		Process = (res) => 
		{
			if(res.data.fails)
				return scope.modal.fails = res.data.fails;

			if(!res.data.success)
				return alert.warning(res.data.message);
			
			alert.success(res.data.message);
			form.modal('edit',false);
			Init();
		}

		ManagerError = (error) => {
			alert.warning(error);
		}

		Clean = () => {
			scope.modal = {model: {},fails: {}};
		}

		Init();
	}

	