app
	.component('appRutas',{
		templateUrl: './views/rutas/rutas.view.html',
		controller: CtrlRutas
	});

	CtrlRutas.$inject = ['$scope','api.service','form.service','alert.service'];

	
	function CtrlRutas(scope,api,form,alert) 
	{
		scope.rutas = [];

		Init = () => 
		{
			scope.spinner = true;

			api.list('Rutas/lista').then(res => {
				scope.rutas = res.data;
			})
			.finally(fin => scope.spinner = false);
		}
		
		
		scope.openModal = (index,object = {}) => 
		{
			Clean();

			switch(index)
			{
				case 1:
					scope.modal.edit = false;
					scope.modal.title = "Agregar Cliente";
					form.modal('edit');
				break;
				case 2:
					scope.modal.edit = true;
					scope.modal.title = "Editar Cliente";
					scope.modal.model = angular.copy(object);
					form.modal('edit');
				break;
			}
		}

		scope.save = () => 
		{
			scope.modal.spinner = true;
			scope.modal.fails   = {};

			let promise;

						
			if(scope.modal.model.id_ruta){
				//Function_cp();
				scope.modal.model.id = scope.modal.model.id_ruta;
				promise = api.update('Rutas',scope.modal.model);
			}else{
				promise = api.store('Rutas',scope.modal.model);
			}

			promise.then(res => Process(res)).catch(error => ManagerError(error)).finally(fin => scope.modal.spinner = false);
		}

		scope.delete = (Rutas) => 
		{
			scope.deleted = Rutas;
			alert.confirm("¡Se eliminara a " + Rutas.descripcion + " de la lista de rutas, esta operación es irreversible!",Delete);
		}

		Delete = (Rutas) => 
		{
			scope.spinner_delete = true;

			api.delete('Rutas',scope.deleted.id_ruta).then(res => {
				if(!res.data.success) return ManagerError(res.data.message);
				alert.success(res.data.message);
				Init();
			})
			.catch(error => ManagerError(error))
			.finally(fin => scope.spinner_delete = false);
		}
		

		Process = (res) => 
		{
			if(res.data.fails)
				return scope.modal.fails = res.data.fails;

			if(!res.data.success)
				return alert.warning(res.data.message);
			
			alert.success(res.data.message);
			form.modal('edit',false);
			Init();
		}

		ManagerError = (error) => {
			alert.warning(error);
		}

		Clean = () => {
			scope.modal = {model: {},fails: {}};
		}

		Init();
	}

	