app.
component('appPantallaPublica',{
	templateUrl: './views/pantalla-publica/pantalla-publica.view.html',
	controller: CtrlPantallaPublica
});

CtrlPantallaPublica.$inject = ['$scope','api.service','alert.service']

function CtrlPantallaPublica(scope,api,alert) 
{
	scope.model = {};
	scope.option_id   = 1;

	Init = () => 
	{
		scope.spinner = true;
		scope.spinner_text = 'Cargando';

		api
		.list('usuario_publico/consulta')
		.then(res => {
			scope.cartas      = res.data.cartas;
			scope.manifiestos = res.data.manifiestos;
		})
		.finally(fin => scope.spinner = false);
	};	

	scope.editCarta = (carta) => 
	{
		scope.spinner = true;
		scope.spinner_text = 'Modificando';

		api
		.update('carta/estado',carta)
		.then(res => {
			if(!res.data.success) return alert.warning(res.data.message);

			alert.success(res.data.message);

			Init();
		})
		.finally(fin => {
			scope.spinner = false;
		})
	}

	scope.editManifiesto = (manifiesto) => 
	{
		scope.spinner = true;
		scope.spinner_text = 'Modificando';

		api
		.update('manifiesto/estado',manifiesto)
		.then(res => 
		{
			if(!res.data.success) return alert.warning(res.data.message);

			alert.success(res.data.message);

			Init();
		})
		.finally(fin => {
			scope.spinner = false;
		})
	}

	scope.descargarCarta = (carta) =>
	{
		carta.spinner = true;
		api
		.downloadPDF('carta/imprimir', carta.numero_desc ,{id: carta.id})
		.finally(fin => carta.spinner = false);
	}

	scope.descargarManifiesto = (manifiesto) =>
	{
		manifiesto.spinner = true;
		api
		.downloadPDF('manifiesto/imprimir', manifiesto.numero_desc ,{id: manifiesto.id})
		.finally(fin => manifiesto.spinner = false);
	}

	Init();
}