app
	.component('appManifiesto',{
		templateUrl: './views/manifiesto/manifiesto.view.html',
		controller: CtrlManifiesto
	});

	CtrlManifiesto.$inject = ['$scope','api.service','form.service','alert.service'];

	function CtrlManifiesto(scope,api,form,alert) 
	{
		Init = () => 
		{
			Clean();
			Parametros();
		}

		Parametros = () => 
		{
			scope.spinner = true;
			scope.spinner_text = "Preparando pantalla";

			api.list('parametro/manifiesto').then(res => {
				scope.paises                              = res.data.paises;
				scope.vehiculos                           = res.data.vehiculos;
				scope.remolques                           = res.data.remolques;
				scope.choferes                            = res.data.choferes;
				scope.naturalezas                         = res.data.naturalezas;
				scope.model.numero_desc                   = res.data.numero;
				scope.model.certificado_idoneidad         = res.data.certificado_idoneidad;
				scope.model.permisos_prestacion_servicios = res.data.permisos_prestacion_servicios;
			})
			.finally(fin => scope.spinner = false);
		}

		Clean = () => 
		{
			scope.title = "Registrar Nuevo Manifiesto";
			scope.model = {
				detalles: []
			};
		}

		scope.openModal = (index,object = {}) =>
		{
			scope.modal = {};

			switch(index)
			{
				case 1:
					scope.modal.title = 'Seleccionar Vehiculo';
					scope.modal.list = scope.vehiculos;
					form.modal('vehiculo');
				break;
				case 2:
					scope.modal.title = 'Seleccionar Remolque';
					scope.modal.list = scope.remolques;
					form.modal('remolque');
				break;
				case 3:
				case 4:
					scope.modal.source = (index == 3) ? 'principal' : 'auxiliar';
					scope.modal.title  = (index == 3) ? 'Seleccionar Conductor Principal' : 'Seleccionar Conductor Auxiliar';
					scope.modal.list   = scope.choferes;
					form.modal('chofer');
				break;
				case 5:
					scope.modal.title = "Seleccionar Carta";
					form.modal('carta');
					scope.modal.spinner = true;
					scope.modal.spinner_text = 'Cargando datos';
					api.list('carta/seleccionar').then(res => scope.modal.list = res.data.cartas).finally(fin => scope.modal.spinner = false);
				break;
				case 6:
					scope.modal.title = 'Seleccionar Manifiesto';
					ConsultarManifiestos();
					form.modal('manifiesto');
				break;
				case 7:
					scope.modal.model = angular.copy(object);
					form.modal('detalle');
				break;
			}
		}

		ConsultarManifiestos = () => 
		{
			scope.modal.spinner = true;
			scope.modal.spinner_text = 'Cargando datos';
			api.list('manifiesto/seleccionar').then(res => scope.modal.list = res.data.manifiestos).finally(fin => scope.modal.spinner = false);
		}

		scope.select = (index,object = {}) =>
		{
			switch(index)
			{
				case 1:
					scope.model.vehiculo    = object;
					scope.model.vehiculo_id = object.id;
					form.modal('vehiculo',false);
				break;
				case 2:
					scope.model.remolque    = object;
					scope.model.remolque_id = object.id;
					form.modal('remolque',false);
				break;
				case 3:
					if(scope.modal.source == 'principal'){
						scope.model.chofer_principal    = object;
						scope.model.chofer_principal_id = object.id;
					}else{
						scope.model.chofer_auxiliar    = object;
						scope.model.chofer_auxiliar_id = object.id;
					}
					form.modal('chofer',false);
				break;
				case 4:
					scope.model.carta    = object;
					scope.model.carta_id = object.id;
					scope.model.detalles = object.detalles;
					form.modal('carta',false);
				break;
			}
		}

		scope.clean = (index) =>
		{
			switch(index)
			{
				case 1:
					scope.model.vehiculo    = null;
					scope.model.vehiculo_id = null;
				break;
				case 2:
					scope.model.remolque    = null;
					scope.model.remolque_id = null;

					scope.model.sin_remolque = !scope.model.sin_remolque;
				break;
				case 3:
					scope.model.chofer_principal    = null;
					scope.model.chofer_principal_id = null;
				break;
				case 4:
					scope.model.chofer_auxiliar    = null;
					scope.model.chofer_auxiliar_id = null;
				break;
				case 5:
					scope.model.sin_carta = !scope.model.sin_carta;

					scope.model.carta     = null;
					scope.model.carta_id  = null;
					scope.model.detalles  = [];
				break;
			}
		}

		scope.save = () =>
		{
			scope.fails = null;

			let numero = parseInt(scope.model.numero_desc);

			if(numero == 0) return alert.warning("Ingrese un número valido.");
			if(!scope.model.chofer_principal_id) return alert.warning("Seleccione el Conductor principal.");
			if(!scope.model.vehiculo_id) return alert.warning("Seleccione un vehiculo.");

			if(!scope.model.sin_remolque){
				if(!scope.model.remolque_id) 
					return alert.warning("Seleccione un remolque.");
			}

			if(!scope.model.sin_carta){
				if(scope.model.detalles.length == 0) 
					return alert.warning("Por favor ingrese por lo menos un detalle.");
			}

			scope.spinner_save = true;

			let data = form.validate(scope.model);
				data.numero = numero;

			api.store('manifiesto',data).then(res => {

				if(res.data.fails){
					scope.fails = res.data.fails;
					alert.warning("Hay campos por corregir.");
					return;
				}

				if(!res.data.success) return alert.warning(res.data.message);
				
				Clean();
				alert.success(res.data.message);
				scope.nuevoManifiesto();
			})
			.finally(fin => scope.spinner_save = false);
		}

		scope.eliminarDetalle = (index) =>
		{
			scope.selected_index = angular.copy(index);
			alert.confirm("¿Desea realmente eliminar el detalle?",EliminarDetalle);
		}

		EliminarDetalle = () =>
		{
			scope.model.detalles.splice(scope.selected_index,1);
			scope.$apply();
		}

		scope.editarDetalle = () => 
		{
			let index = scope.model.detalles.findIndex(d => d.id == scope.modal.model.id);
			scope.model.detalles[index] = scope.modal.model;
			form.modal('detalle',false);
		}

		scope.editar = (object) => 
		{
			scope.model = object;
			form.parse(scope.model);
			form.modal('manifiesto',false);
		}

		scope.download = (manifiesto) =>
		{
			manifiesto.spinner = true;
			api
			.downloadPDF('manifiesto/imprimir', 'manifiesto_'+manifiesto.numero_desc ,{id: manifiesto.id})
			.finally(fin => manifiesto.spinner = false);
		}

		scope.nuevoManifiesto = () => 
		{
			scope.spinner = true;
			scope.spinner_text = 'Preparando nuevo manifiesto';
			scope.fails = null;
			Clean();
			api.list('parametro/manifiesto_numero')
			.then(res => {
				scope.fails                               = null;
				scope.model.numero_desc                   = res.data.numero;
				scope.model.certificado_idoneidad         = res.data.certificado_idoneidad;
				scope.model.permisos_prestacion_servicios = res.data.permisos_prestacion_servicios;
				scope.spinner                             = false;
			})
			.catch(error => alert.warning(error));
		}

		scope.$watch('model.carga_naturaleza_id',id => {
			if(id){
				let found = scope.naturalezas.find(n => n.id == id);
				scope.model.carga_naturaleza = found.name;	
			}
		});

		Init();
	}