app
	.component('appGuialista',{
		templateUrl: './views/guialista/guialista.view.html',
		controller: CtrlGuialista
	});

	CtrlGuialista.$inject = ['$scope','api.service','form.service','alert.service'];

	function CtrlGuialista(scope,api,form,alert) 
	{
		
		scope.guiatrans = [];
		

		Init = () => 
		{
			scope.spinner = true;
			
			api.list('Guiatrans/listaall').then(res => {
				scope.guiatrans = res.data;
			})
			.finally(fin => scope.spinner = false);
		}

		scope.dowloadfile = (guiatrans) => 
		{
			
			window.open(guiatrans.file_attached, '_blank');
		}

		scope.delete = (guiaall) => 
			{
				scope.deleted = guiaall;
				alert.confirm("¡Se desvinculara la factura "  + guiaall.venta.serie+ '-' + guiaall.venta.numero+ " de la guia "+ guiaall.serie_guiatrans+ '-' + guiaall.nro_guiatrans+" ,esta operación es irreversible!",Delete);		
			}
	
		Delete = (guiaall) => 
		{
			scope.spinner_delete = true;

			api.delete('Guiatrans',scope.deleted.id).then(res => {
				if(!res.data.success) return ManagerError(res.data.message);
				alert.success(res.data.message);
				Init();
			})
			.catch(error => ManagerError(error))
			.finally(fin => scope.spinner_delete = false);
		}

		/*
		scope.upestatus = (guiaall) => {
			scope.deleted = guiaall;
			alert.confirm("¡Se actualizara el estado de la Guia "  +  guiaall.serie_guiatrans+ '-' + guiaall.nro_guiatrans+" ,esta operación es irreversible!",Upstatus);		
		}


		Upstatus = (guiaall)=>
		{
			scope.spinner_delete = true;

			api.list('Guiatrans/upestatus/' + scope.deleted.id).then(res => {
				if(!res.data.success) return ManagerError(res.data.message);
				alert.success(res.data.message);
				Init();
			})
			.catch(error => ManagerError(error))
			.finally(fin => scope.spinner_delete = false);
		}
		*/

		scope.upestatus = () => 
			{
				scope.modal.spinner = true;
				scope.modal.fails   = {};
	
				let promise;
	
				promise= api.list('Guiatrans/upestatus/' + scope.modal.model.id);
				promise.then(res => Process(res)).catch(error => ManagerError(error)).finally(fin => scope.modal.spinner = false);
			}


		scope.openModal = (index,object = {}) => 
			{
				Clean();
	
				switch(index)
				{
					case 1:
						scope.modal.edit = false;
						scope.modal.title = "Actualizar estado SUNAT";
						scope.modal.model = angular.copy(object);
						form.modal('edit');
					break;
					
				}
			}

	
		Process = (res) => 
		{
			if(res.data.fails)
				return scope.modal.fails = res.data.fails;

			if(!res.data.success)
				return alert.warning(res.data.message);
			
			alert.success(res.data.message);
			form.modal('edit',false);
			Init();
		}

		ManagerError = (error) => {
			alert.warning(error);
		}

		Clean = () => {
			scope.modal = {model: {},fails: {}};
		}

		Init();
	}

	