
app
	.component('appCompras',{
		templateUrl: './views/compras/compras.view.html',
		controller: CtrlCompras
	});

	CtrlCompras.$inject = ['$scope','api.service','form.service','alert.service'];


	function CtrlCompras(scope,api,form,alert) 
	{
		scope.compras = [];
		scope.Tipodoccompra = [];
		scope.consun = [];

		Init = () => 
		{
			scope.spinner = true;

			api.list('compras/parametros').then(res => {
				scope.Tipodoccompra = res.data.tipodoccompra;
				
			})

			api.list('compras/lista').then(res => {
				scope.compras = res.data;
			})

			.finally(fin => scope.spinner = false);
		}

		scope.delete = (compras) => 
		{
			scope.deleted = compras;
			alert.confirm("¡Se eliminara a " + compras.serie + "-"+compras.numero+" ["+compras.razonsocial+"] de la lista de documentos, esta operación es irreversible!",Delete);
		}

		Delete = (compras) => 
		{
			scope.spinner_delete = true;

			api.delete('compras',scope.deleted.id).then(res => {
				if(!res.data.success) return ManagerError(res.data.message);
				alert.success(res.data.message);
				Init();
			})
			.catch(error => ManagerError(error))
			.finally(fin => scope.spinner_delete = false);
		}


		
		scope.openModal = (index,object = {}) => 
		{
			Clean();

			switch(index)
			{
				case 1:
					scope.modal.edit = false;
					scope.modal.title = "Agregar Compra";
					form.modal('edit');
				break;

				
				case 3:
					scope.modal.edit = false;
					scope.modal.title = "Agregar Compra";
					form.modal('addauto');
				break;
				
			}
		}

	
		scope.save = () => 
		{
			scope.modal.spinner = true;
			scope.modal.fails   = {};
			let vtotal=scope.modal.model.total
			//if(parseInt(vtotal) <= 0) return alert.warning("Ingrese el monto total");
			//Validaciones
			if(vtotal > 0){
				let promise;
				let usua  = JSON.parse(localStorage.getItem(AUTH_KEY));

				const data = {
					id_tipo : scope.modal.model.id_tipo,
					fecha : formatDate(scope.modal.model.fecha),
					serie : scope.modal.model.serie,
					numero : scope.modal.model.numero,
					ruc : scope.modal.model.ruc,
					razonsocial : scope.modal.model.razonsocial,
					moneda : scope.modal.model.moneda,
					baseimponible : scope.modal.model.baseimponible,
					igv : scope.modal.model.igv,
					total : scope.modal.model.total,
					tipo_ingreso:'Manual',
					usuario_ingreso:usua.nombres
					}
				promise = api.store('compras',data);
				promise.then(res => Process(res)).catch(error => ManagerError(error)).finally(fin => scope.modal.spinner = false);
			}else{
				scope.modal.spinner = false;
				return alert.warning("Ingrese el monto total");
			}
	
		}


		scope.savetwo = () => 
		{
			scope.modal.spinner = true;
			scope.modal.fails   = {};
			
			let usua  = JSON.parse(localStorage.getItem(AUTH_KEY));
			
			let promise;
			
			promise = api.store('compras/apisu', {
													param1: scope.modal.model.ruc,
													param2: scope.modal.model.serie,
													param3: scope.modal.model.numero,
													param4: usua.nombres
												})

			promise.then(res => Process(res)).catch(error => ManagerError(error)).finally(fin => scope.modal.spinner = false);
		}
	

		Process = (res) => 
		{
			if(res.data.fails)
				return scope.modal.fails = res.data.fails;

			if(!res.data.success)
				return alert.warning(res.data.message);
			
			alert.success(res.data.message);
			form.modal('edit',false);
			form.modal('addauto',false);
			Init();
		}

		ManagerError = (error) => {
			alert.warning(error);
		}

		Clean = () => {
			scope.modal = {model: {},fails: {}};
		}

		Init();
	}

	function formatDate(date) {
		var d = new Date(date),
			month = '' + (d.getMonth() + 1),
			day = '' + d.getDate(),
			year = d.getFullYear();
	
		if (month.length < 2) 
			month = '0' + month;
		if (day.length < 2) 
			day = '0' + day;
	
		return [year, month, day].join('-');
	}


