app
	.component('appChoferes',{
		templateUrl: './views/choferes/choferes.view.html',
		controller: CtrlChoferes
	});

	CtrlChoferes.$inject = ['$scope','api.service','form.service','alert.service'];

	function CtrlChoferes(scope,api,form,alert) 
	{
		Init = () => 
		{
			scope.spinner = true;
			Paises();
			Choferes();
		}

		Paises = () => 
		{
			api.list('pais').then(res => scope.paises = res.data.paises);
		}

		Choferes = () => 
		{
			scope.spinner = true;
			api.list('chofer').then(res => {
				scope.choferes = res.data.choferes;
			})
			.finally(fin => scope.spinner = false);
		}

		scope.openModal = (index,object = {}) => 
		{
			Clean();

			switch(index)
			{
				case 1:
					scope.modal.edit = false;
					scope.modal.title = "Agregar Chofer";
					form.modal('edit');
				break;
				case 2:
					scope.modal.edit = true;
					scope.modal.title = "Editar Chofer";
					scope.modal.model = angular.copy(object);
					form.modal('edit');
				break;
			}
		}

		scope.save = () => 
		{
			scope.modal.spinner = true;
			scope.modal.fails   = {};

			let promise;

			if(scope.modal.model.id){
				promise = api.update('chofer',scope.modal.model);
			}else{
				promise = api.store('chofer',scope.modal.model);
			}

			promise.then(res => Process(res)).catch(error => ManagerError(error)).finally(fin => scope.modal.spinner = false);
		}

		scope.delete = (chofer) => 
		{
			scope.deleted = chofer;
			alert.confirm("¡Se eliminara a " + chofer.nombres + " de la lista de choferes, esta operación es irreversible!",Delete);
		}

		Delete = (chofer) => 
		{
			scope.spinner_delete = true;

			api.delete('chofer',scope.deleted.id).then(res => {
				if(!res.data.success) return ManagerError(res.data.message);
				alert.success(res.data.message);
				Choferes();
			})
			.catch(error => ManagerError(error))
			.finally(fin => scope.spinner_delete = false);
		}

		Process = (res) => 
		{
			if(res.data.fails)
				return scope.modal.fails = res.data.fails;

			if(!res.data.success)
				return alert.warning(res.data.message);
			
			alert.success(res.data.message);
			form.modal('edit',false);
			Choferes();
		}

		ManagerError = (error) => {
			alert.warning(error);
		}

		Clean = () => {
			scope.modal = {model: {},fails: {}};
		}

		Init();
	}