app
	.component('appCarta',{
		templateUrl: './views/carta/carta.view.html',
		controller: CtrlCarta
	});

	CtrlCarta.$inject = ['$scope','api.service','form.service','alert.service','monedas.factory','$rootScope'];

	function CtrlCarta(scope,api,form,alert,monedasFactory,root) 
	{
		Init = () => 
		{
			Clean();
			Parametros();
		}

		Parametros = () => 
		{
			scope.spinner = true;
			scope.spinner_text = "Preparando pantalla";

			api.list('parametro/carta').then(res => {
				scope.monedas           = res.data.monedas;
				scope.moneda_default    = res.data.moneda_default;
				scope.paises            = res.data.paises;
				scope.model.numero_desc = res.data.numero;
			})
			.finally(fin => scope.spinner = false);
		}

		Clean = () => 
		{
			scope.title = "Registrar Nueva Carta";

			let now = new Date();

			scope.model = {
				// recepcion_pais_id: 1,
				// embarque_pais_id: 1,
				// entrega_pais_id: 1,
				// emision_pais_id: 1,

				// recepcion_fecha: now,
				// embarque_fecha: now,
				// entrega_fecha: now,
				// emision_fecha: now,
				
				// gasto_moneda: scope.moneda_default,

				detalles: [],
			};
		}

		scope.openModal = (index,object = {}) =>
		{
			scope.modal = {};

			switch(index)
			{
				case 1:
					scope.modal.title = 'Agregar Detalle';
					scope.modal.model_detalle = {};
					form.modal('detalle');
				break;
				case 2:

				break;
				//Seleccionar carta
				case 3:
					scope.modal.title = 'Seleccionar Carta';
					ConsultarCartas();
					form.modal('cartas');
				break;
			}
		}

		ConsultarCartas = () => 
		{
			scope.modal.spinner = true;
			scope.modal.spinner_text = 'Cargando datos';
			api.list('carta/seleccionar').then(res => scope.modal.list = res.data.cartas).finally(fin => scope.modal.spinner = false);
		}

		scope.addDetalle = () => 
		{
			scope.model.detalles.push(scope.modal.model_detalle);
			form.modal('detalle',false);
		}

		scope.nuevaCarta = () =>
		{
			scope.spinner = true;
			scope.spinner_text = 'Preparando nueva carta';
			Clean();
			api.list('parametro/carta_numero')
			.then(res => {
				scope.fails = null;
				scope.model.numero_desc = res.data.numero;
				scope.spinner = false;
			})
			.catch(error => alert.warning(error));
		}

		scope.save = () => 
		{
			let numero = parseInt(scope.model.numero_desc);

			if(numero == 0) return alert.warning("Ingrese un número valido.");

			if(scope.model.detalles.length == 0) return alert.warning("Agregue detalles a la carta.");

			scope.spinner_save = true;
			scope.fails        = null;

			let data = form.validate(scope.model);
				data.numero = numero;

			api.store('carta',data).then(res => {

				if(res.data.fails){
					scope.fails = res.data.fails;
					alert.warning("Hay campos por corregir.");
					root.top();
					return;
				}

				if(!res.data.success) return alert.warning(res.data.message);
				
				Clean();
				alert.success(res.data.message);
				scope.nuevaCarta();
			})
			.finally(fin => scope.spinner_save = false);
		}

		scope.editar = (carta) => 
		{
			CargarCarta(carta);

			form.modal('cartas',false);
		}

		CargarCarta = (carta) => 
		{
			form.parse(carta);

			scope.model = angular.copy(carta);

			scope.title = "Editar Carta N° " + carta.numero_desc;
		}

		scope.mago = (carta) => 
		{
			scope.selected = carta;
			alert.confirm("¡Se copiara la carta " + carta.numero_desc + "!",Mago);
		}

		Mago = () =>
		{
			scope.modal.spinner = true;
			scope.modal.spinner_text = 'Copiando datos de carta';
			api.store('carta/mago',{id: scope.selected.id}).then(res => {
				if(!res.data.success) return alert.warning(res.data.message);

				alert.success(res.data.message);
				CargarCarta(res.data.carta);
				form.modal('cartas',false);
			})
			.finally(fin => scope.modal.spinner = false);
		}

		scope.eliminarDetalle = (index) =>
		{
			scope.selected_index = angular.copy(index);
			alert.confirm("¿Desea realmente eliminar el detalle?",EliminarDetalle);
		}

		EliminarDetalle = () =>
		{
			scope.model.detalles.splice(scope.selected_index,1);
			scope.$apply();
		}

		scope.download = (carta) =>
		{
			carta.spinner = true;
			api
			.downloadPDF('carta/imprimir', 'carta_'+carta.numero_desc ,{id: carta.id})
			.finally(fin => carta.spinner = false);
		}

		Init();
	}