app.service('api.service',ApiService);

ApiService.$inject = ['$http','$window'];

function ApiService(http,window) 
{
	const API      = '../api/public/index.php/api/';
	const token    = localStorage.getItem('guias_token_key');
	const endPoint = '?api_token=' + token;

	this.list = (model) => {
		return Check(http.get(API + model + endPoint));
	}

	this.store = (model,data) => {
		return Check(http.post(API + model + '/store' + endPoint ,data));
	}

	this.update = (model,data) => {
		return Check(http.put(API + model + '/update/' + data.id + endPoint,data));
	}

	this.delete = (model,id) => {
		return Check(http.delete(API + model + '/delete/' + id + endPoint));
	}

	this.post = (route, formdata) => {
		const requestOptions = {
			method: 'POST',
			body: formdata,
			redirect: 'follow'
		}
		
		const basepath = 'https://www.transcarr.com/sisdoc/app_movil/';
		return fetch(basepath + route, requestOptions);
	}

	Check = (promise) => 
	{
		promise.catch(error => {
			if(error.status == 401)
				this.logout();
		});

		return promise;
	}

	this.logout = () => {
		localStorage.clear();
		window.location = '../login';
	}

	this.downloadPDF = function ( route, name , data ) 
    {
        return http({
            url: API + route + endPoint,
            method: 'POST',
            params: data,
            headers: {
                'Content-type': "application/pdf",
            },
            responseType: 'blob'
        }).then(function (res) {

            var file = new Blob([res.data], {
                type: "application/pdf"
            });
            var fileURL = URL.createObjectURL(file);
            var a = document.createElement('a');
            a.href = fileURL;
            a.target = '_blank';
            a.download = name + '.pdf';
            document.body.appendChild(a);
            a.click();
        });    
    }
}