<!DOCTYPE html>
<html lang="en">
<head>
	<meta charset="UTF-8">
	<title>Document</title>
	<link href="<?php echo e(asset('css/grid.css')); ?>" rel="stylesheet">
	<style>
		.table{
			border: solid 2px black;
			width: 700px;
			font-size: 12px;
			font-family: Calibri;
		}
		td{
			padding-left: 5px;
			padding-right: 5px;
			padding-top: 2px;
			padding-bottom: 2px;
		}
		.border-bottom{
			border-bottom: solid 1px black;
		}
		.border-top{
			border-top: solid 1px black;
		}
		.border-left{
			border-left: solid 1px black;
		}
		.border-right{
			border-right: solid 1px black;
		}
		.text-center{
			text-align: center;
		}
		.text-right{
			text-align: right;
		}
		strong{
			font-size: 12px;
		}
		.td-no-padding td{
			padding: 0px;
		}
		.no-padding{
			padding: 0px;
		}
		.d-block{
			display: block;
		}
		.row-center{
			display: block;
			text-align: center;
		}
		.v-top{
			vertical-align: top;
		}
	</style>
</head>
<body>
	<table width="700px;" class="table">
		<tr>
			<td rowspan="2" style="text-align: center;padding: 0px;height: 80px;width: 320px;" class="border-right">
				<img src="<?php echo e(asset('images/logo.png')); ?>" alt="" height="50px" width="100px">
				<br>
				<strong>COMUNIDAD ANDINA</strong>
			</td>
			<td style="font-weight: bold;text-align: center;width: 320px;" class="border-bottom">
				Manifiesto de Carga Internacional (MCI)
			</td>
		</tr>
		<tr style="width: 350px;">
			<td>
				<table style="width: 100%;">
					<tr style="font-size: 18px;font-weight: bold;color: red;">
						<td colspan="1">
							N°
						</td>
						<td colspan="4" style="text-align: center;">
							<?php echo e($manifiesto->numero_desc); ?>

						</td>
					</tr>
				</table>
			</td>
		</tr>
		<tr>
			<td colspan="2" class="text-center border-top border-bottom">
				<strong>IDENTIFICACIÓN DEL TRANSPORTISTA AUTORIZADO</strong>
			</td>
		</tr>
		<tr>
			<td style="width: 320px;padding: 0px;" class="border-right v-top">
				<small><strong>1</strong> Denominación o razon social del transportista autorizado</small>
				<br>
				<img src="<?php echo e(asset('images/logo_trans_carr.png')); ?>" alt="" height="100px" width="345px">
			</td>
			<td class="v-top" style="padding: 0px;width: 320px;">
				<table>
					<tr>
						<td class="border-bottom" style="width: 320px;"> 
							<small><strong>2</strong> Certificado de idoneidad N° </small>
						</td>		
					</tr>
					<tr>
						<td class="text-center border-bottom" style="width: 320px;">
							<br>
							<strong><?php echo e($manifiesto->certificado_idoneidad); ?></strong>			
						</td>
					</tr>
					<tr>
						<td class="border-bottom" style="width: 320px;">
							<small><strong>3</strong> Permisos de prestación de servicios N°</small>			
						</td>
					</tr>
					<tr>
						<td class="text-center" style="width: 320px;">
							<br>
							<strong><?php echo e($manifiesto->permisos_prestacion_servicios); ?></strong>			
						</td>
					</tr>
				</table>
			</td>
		</tr>	
		<tr>
			<td colspan="2" class="text-center border-top border-bottom">
				<strong>IDENTIFICACIÓN DEL VEHICULO HABILITADO (CAMIÓN O TRACTO CAMIÓN)</strong>
			</td>
		</tr>
		<tr>
			<td style="padding: 0px;width: 320px;">
				<table>
					<tr>
						<td style="padding: 0px;width: 170px;" class="border-right">
							<small><strong>4</strong> Marca</small>
							<br>
							<strong class="row-center"><?php echo e($manifiesto->vehiculo->marca); ?></strong>
						</td>
						<td style="padding: 0px;width: 170px;" class="border-right">
							<small><strong>5</strong> Año de Fabricación</small>
							<br>
							<strong class="row-center"><?php echo e($manifiesto->vehiculo->anio); ?></strong>
						</td>
					</tr>
				</table>
			</td>
			<td style="padding: 0px;width: 320px;">
				<table>
					<tr>
						<td style="padding: 0px;width: 170px;" class="border-right">
							<small><strong>6</strong> Placa y País</small>
							<br>
							<strong class="row-center">
								<?php echo e($manifiesto->vehiculo->placa); ?> - <?php echo e($manifiesto->vehiculo->pais->nombre); ?>

							</strong>
						</td>
						<td style="padding: 0px;width: 170px;">
							<small><strong>7</strong> Número o serie del chasis</small>
							<br>
							<strong class="row-center"><?php echo e($manifiesto->vehiculo->chasis); ?></strong>
						</td>
					</tr>
				</table>
			</td>
		</tr>
		<tr>
			<td style="padding: 0px;width: 320px;" class="border-top border-right">
				<small><strong>8</strong> Certificado de Habilitacion N°</small>
				<br>
				<strong class="row-center"><?php echo e($manifiesto->vehiculo->certificado_habilitacion); ?></strong>
			</td>
			<td style="padding: 0px;width: 320px;" class="border-top">
			</td>
		</tr>		
		<tr>
			<td colspan="2" class="text-center border-top border-bottom">
				<strong>IDENTIFICACIÓN DE LA UNIDAD DE CARGA (REMOLQUE O SEMI-REMOLQUE)</strong>
			</td>
		</tr>
		<tr>
			<td style="padding: 0px;width: 320px;">
				<table>
					<tr>
						<td style="padding: 0px;width: 170px;" class="border-right">
							<small><strong>9</strong> Marca</small>
							<br>
							<strong class="row-center"><?php echo e($manifiesto->remolque->marca); ?></strong>
						</td>
						<td style="padding: 0px;width: 170px;" class="border-right">
							<small><strong>10</strong> Año de Fabricación</small>
							<br>
							<strong class="row-center"><?php echo e($manifiesto->remolque->anio); ?></strong>
						</td>
					</tr>
				</table>
			</td>
			<td style="padding: 0px;width: 320px;">
				<table>
					<tr>
						<td style="padding: 0px;width: 170px;" class="border-right">
							<small><strong>11</strong> Placa y País</small>
							<br>
							<strong class="row-center">
								<?php echo e($manifiesto->remolque->placa); ?> - <?php echo e($manifiesto->remolque->pais->nombre); ?>

							</strong>
						</td>
						<td style="padding: 0px;width: 170px;">
							<small><strong>12</strong> N° chasis</small>
							<br>
							<strong class="row-center"><?php echo e($manifiesto->remolque->chasis); ?></strong>
						</td>
					</tr>
				</table>
			</td>
		</tr>
		<tr>
			<td colspan="2" class="text-center border-top border-bottom">
				<strong>IDENTIFICACIÓN DE LA TRIPULACIÓN</strong>
			</td>
		</tr>
		<tr>
			<td style="padding: 0px;width: 320px;" class="border-right border-bottom">
				<small><strong>13</strong> Conductor principal: Nombres y apellidos</small>
				<br><br>
				<strong class="row-center"><?php echo e($manifiesto->choferPrincipal->nombres); ?></strong>
			</td>
			<td style="padding: 0px;width: 320px;" class="border-bottom v-top">
				<small><strong>18</strong> Conductor Auxiliar: Nombres y apellidos</small>
				<br><br>
				<strong class="row-center">
					<?php echo e(($manifiesto->choferAuxiliar) ? $manifiesto->choferAuxiliar->nombres : ''); ?>

				</strong>
			</td>
		</tr>
		<tr>
			<td style="padding: 0px;width: 320px;">
				<table>
					<tr>
						<td style="padding: 0px;width: 170px;" class="border-right border-bottom">
							<small><strong>14</strong> Documento de Identidad</small>
							<br><br>
							<strong class="row-center"><?php echo e($manifiesto->choferPrincipal->documento_identidad); ?></strong>
						</td>
						<td style="padding: 0px;width: 170px;" class="border-right border-bottom">
							<small><strong>15</strong> Nacionalidad</small>
							<br><br>
							<strong class="row-center"><?php echo e($manifiesto->choferPrincipal->nacionalidad); ?></strong>
						</td>
					</tr>
				</table>
			</td>
			<td style="padding: 0px;width: 320px;">
				<table>
					<tr>
						<td style="padding: 0px;width: 170px;height: 42px;" class="border-right border-bottom v-top">
							<small><strong>19</strong> Documento de Identidad</small>
							<br><br>
							<strong class="row-center">
								<?php echo e(($manifiesto->choferAuxiliar) ? $manifiesto->choferAuxiliar->documento_identidad : ''); ?>

							</strong>
						</td>
						<td style="padding: 0px;width: 170px;height: 42px;" class="border-bottom v-top">
							<small><strong>20</strong> Nacionalidad</small>
							<br><br>
							<strong class="row-center">
								<?php echo e(($manifiesto->choferAuxiliar) ? $manifiesto->choferAuxiliar->nacionalidad : ''); ?>

							</strong>
						</td>
					</tr>
				</table>
			</td>
		</tr>
		<tr>
			<td style="padding: 0px;width: 320px;" class="v-top">
				<table>
					<tr>
						<td style="padding: 0px;width: 170px;" class="border-right v-top">
							<small><strong>16</strong> Licencia de Conducir N°</small>
							<br>
							<strong class="row-center"><?php echo e($manifiesto->choferPrincipal->licencia); ?></strong>
						</td>
						<td style="padding: 0px;width: 170px;" class="border-right v-top">
							<small><strong>17</strong> Libreta de tripulante terrestre</small>
							<br>
							<strong class="row-center"><?php echo e($manifiesto->choferPrincipal->libreta); ?></strong>
						</td>
					</tr>
				</table>
			</td>
			<td style="padding: 0px;width: 320px;" class="v-top">
				<table>
					<tr>
						<td style="padding: 0px;width: 170px;height: 30px;" class="border-right v-top">
							<small><strong>21</strong> Licencia de Conducir N°</small>
							<br>
							<strong class="row-center">
								<?php echo e(($manifiesto->choferAuxiliar) ? $manifiesto->choferAuxiliar->licencia : ''); ?>

							</strong>
						</td>
						<td style="padding: 0px;width: 170px;height: 30px;" class="v-top">
							<small><strong>22</strong> Libreta de tripulante terrestre</small>
							<br>
							<strong class="row-center">
								<?php echo e(($manifiesto->choferAuxiliar) ? $manifiesto->choferAuxiliar->libreta : ''); ?>

							</strong>
						</td>
					</tr>
				</table>
			</td>
		</tr>
		<tr>
			<td colspan="2" class="text-center border-top border-bottom">
				<strong>DATOS SOBRE LA CARGA</strong>
			</td>
		</tr>
		<tr>
			<td style="padding: 0px;width: 320px;" class="border-right border-bottom">
				<small><strong>23</strong> Lugar y País de carga</small>
				<br>
				<strong class="row-center">
					<?php echo e($manifiesto->carga_lugar); ?> - <?php echo e(($manifiesto->cargaPais) ? $manifiesto->cargaPais->nombre : ''); ?>

				</strong>
			</td>
			<td style="padding: 0px;width: 320px;" class="border-bottom">
				<small><strong>24</strong> Lugar y País de descarga</small>
				<br>
				<strong class="row-center">
					<?php echo e($manifiesto->descarga_lugar); ?> - <?php echo e(($manifiesto->descargaPais) ? $manifiesto->descargaPais->nombre : ''); ?>

				</strong>
			</td>
		</tr>
		<tr>
			<td colspan="2" style="padding: 0px;border-bottom: solid 2px black;">
				<table>
					<tr>
						<td style="padding: 0px;width: 200px;" class="border-right v-top">
							<small><strong>25</strong> Naturaleza de la carga</small>
							<br><br>
							<strong class="row-center"><?php echo e($manifiesto->carga_naturaleza); ?></strong>
						</td>
						<td style="padding: 0px;width: 240px;" class="border-right">
							<small>
								<strong>26</strong> Número de identificación de los contenedores y su capacidad (indicar si son de 20 ó 40 pies u otra)
							</small>
							<br><br>
							<strong class="row-center"><?php echo e($manifiesto->num_iden_contenedor_capacidad); ?></strong>
						</td>
						<td style="padding: 0px;width: 200px;" class="v-top">
							<small><strong>27</strong> Número de los precintos aduaneros</small>
							<br><br>
							<strong class="row-center"><?php echo e($manifiesto->num_precintos_aduaneros); ?></strong>
						</td>
					</tr>
				</table>
			</td>
		</tr>
		<tr>
			<td colspan="2" style="padding: 0px;color: black;border-bottom: solid 2px black;">
				<table>
					<tr>
						<td style="padding: 0px;width: 100px;" class="text-center border-right">
							<small>28 Carta de porte N°</small>
						</td>
						<td style="padding: 0px;width: 180px;" class="border-right text-center">
							<small>29 Descripción de las mercancias</small>
						</td>
						<td style="padding: 0px;width: 70px;" class="border-right text-center">
							<small>30 Cantidad de los bultos</small>
						</td>
						<td style="padding: 0px;width: 120px;" class="border-right text-center">
							<small>31 Clase y marca de los bultos</small>
						</td>
						<td style="padding: 0px;width: 120px;" class="border-right text-center v-top" colspan="2">
							<table>
								<tr>
									<td colspan="2" class="text-center border-bottom v-top" style="padding: 0px;width: 120px;">
										<small>32 Peso en kilogramos</small>
										<br><br>
									</td>
								</tr>
								<tr>
									<td class="text-center border-right" style="padding: 0px;width: 60px;">
										<small>BRUTO</small>
									</td>
									<td class="text-center" style="padding: 0px;width: 60px;">
										<small>NETO</small>
									</td>
								</tr>
							</table>
						</td>
						<td style="padding: 0px;width: 70px;" class="text-center">
							<small>33 Volumen en m3 u otra unidad de medida</small>
						</td>
					</tr>
				</table>
			</td>
		</tr>
		<?php if(count($manifiesto->detalles) > 0): ?>
			<?php $__currentLoopData = $manifiesto->detalles; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $detalle): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
			<tr>
				<td colspan="2" style="padding: 0px;width: 640px;border-bottom: solid 2px black;">
					<table>
						<tr>
							<td style="padding: 0px;width: 100px;" class="border-right text-center">
								<small><?php echo e($manifiesto->numero_desc); ?></small>
							</td>
							<td style="padding: 0px;width: 185px;" class="border-right text-center">
								<small><?php echo e($detalle->descripcion); ?></small>
							</td>
							<td style="padding: 0px;width: 70px;" class="border-right text-center">
								<small><?php echo e($detalle->cantidad_bulto); ?></small>
							</td>
							<td style="padding: 0px;width: 125px;" class="border-right text-center">
								<small><?php echo e($detalle->clase_marca); ?></small>
							</td>
							<td style="padding: 0px;width: 60px;" class="border-right text-center">
								<small><?php echo e(number_format($detalle->bruto,2,'.',',')); ?></small>
							</td>
							<td style="padding: 0px;width: 60px;" class="border-right text-center">
								<small><?php echo e(number_format($detalle->neto,2,'.',',')); ?></small>
							</td>
							<td style="padding: 0px;width: 70px;" class="text-center">
								<small><?php echo e(number_format($detalle->volumen,2,'.',',')); ?></small>
							</td>
						</tr>
					</table>
				</td>
			</tr>
			<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
		<?php endif; ?>
		<tr>
			<td colspan="2" style="padding: 0px;border-bottom: solid 2px black;">
				<table>
					<tr>
						<td style="width: 360px;padding: 0px;" class="border-right">
							<strong>34. Precio de las mercancias (INCOTERMS 1990) y tipo de moneda</strong>
						</td>
						<td style="width: 125px;padding: 0px;" class="text-center border-right">
							<strong>TOTAL</strong>
						</td>
						<td style="width: 60px;padding: 0px;" class="text-center border-right">
							<small><?php echo e(number_format($manifiesto->detalles->sum('bruto'),2,'.',',')); ?></small>
						</td>
						<td style="width: 60px;padding: 0px;" class="text-center border-right">
							<small><?php echo e(number_format($manifiesto->detalles->sum('neto'),2,'.',',')); ?></small>
						</td>
						<td style="width: 70px;padding: 0px;"></td>
					</tr>
				</table>
			</td>
		</tr>
		<tr>
			<td colspan="2" style="padding: 0px;" class="border-bottom">
				<table>
					<tr>
						<td style="padding: 0px;width: 350px;" class="border-right">
							<small>35 Observaciones de la aduana de partida</small>
							<br><br>
							<strong class="row-center"><?php echo e($manifiesto->aduana_observacion); ?></strong>
						</td>
						<td style="padding: 0px;width: 160px;" class="border-right">
							<small>
								37 Aduana(s) de cruce de frontera
							</small>
							<br><br>
							<strong class="row-center"><?php echo e($manifiesto->aduana_cruce_frontera); ?></strong>
						</td>
						<td style="padding: 0px;width: 160px;">
							<small>38 Aduana de destino</small>
							<br><br>
							<strong class="row-center"><?php echo e($manifiesto->aduana_destino); ?></strong>
						</td>
					</tr>
				</table>
			</td>
		</tr>
		<tr>
			<td style="padding: 0px;width: 320px;" class="v-top">
				<table>
					<tr>
						<td style="padding: 0px;width: 340px;height: 70px;" class="v-top">
							<small>36. Firma y sello de la autoridad que interviene en la aduana de partida</small>
							<br>
							<br>
							<br>
						</td>
					</tr>
					<tr>
						<td class="border-top v-top">
							<small>40. Fecha de emisión</small>
							<br>
							<strong class="row-center"><?php echo e($manifiesto->iso_fecha_emision); ?></strong>
						</td>
					</tr>
				</table>
			</td>
			<td style="width: 320px;" class="border-left v-top">
				<small>El suscrito al hacerse cargo de las mercancías, se obliga a cumplir con las disposiciones de las normas que conforman el ordenamiento jurídico de la Comunidad Andina, de </small>
				<br>
				<br>
				<br>
				<small>39. Nombre, Firma y Sello del transportista Autorizado a su representante o agente</small>
			</td>
		</tr>
	</table>

	<table class="table">
		<tr>
			<td style="width: 700px;">
				<h3 class="row-center">CONDICIONES GENERALES</h3>
				<small style="white-space: pre-line;width: 600px;">
					<?php echo e($condiciones->valor); ?>

				</small>
			</td>
		</tr>
	</table>
</body>
</html><?php /**PATH C:\xampp7\htdocs\dc\guias\api\resources\views/pdf/manifiesto.blade.php ENDPATH**/ ?>