<?php

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| is assigned the "api" middleware group. Enjoy building your API!
|
*/

Route::middleware('auth:api')->get('/user', function (Request $request) {
    return $request->user();
});

Route::post('login','UsuarioCtrl@login');


Route::group(['middleware' => ['auth:api','check'] ],function ()
{
	Route::group(['prefix' => 'chofer'],function ()
	{
		Route::get('','ChoferCtrl@index');
		Route::post('store','ChoferCtrl@store');
		Route::put('update/{id}','ChoferCtrl@update');
		Route::delete('delete/{id}','ChoferCtrl@delete');
	});

	Route::group(['prefix' => 'pais'],function ()
	{
		Route::get('','PaisCtrl@index');
		Route::post('store','PaisCtrl@store');
		Route::put('update/{id}','PaisCtrl@update');
		Route::delete('delete/{id}','PaisCtrl@delete');
	});

	Route::group(['prefix' => 'remolque'],function ()
	{
		Route::get('','RemolqueCtrl@index');
		Route::post('store','RemolqueCtrl@store');
		Route::put('update/{id}','RemolqueCtrl@update');
		Route::delete('delete/{id}','RemolqueCtrl@delete');
	});

	Route::group(['prefix' => 'vehiculo'],function ()
	{
		Route::get('','VehiculoCtrl@index');
		Route::post('store','VehiculoCtrl@store');
		Route::put('update/{id}','VehiculoCtrl@update');
		Route::delete('delete/{id}','VehiculoCtrl@delete');
	});

	Route::group(['prefix' => 'usuario'],function ()
	{
		Route::get('auth','UsuarioCtrl@auth');
		Route::post('password/store','UsuarioCtrl@storePassword');

		Route::get('','UsuarioCtrl@index');
		Route::post('store','UsuarioCtrl@store');
		Route::put('update/{id}','UsuarioCtrl@update');
		Route::delete('delete/{id}','UsuarioCtrl@delete');
	});

	Route::group(['prefix' => 'usuario_publico'],function ()
	{
		Route::get('','UsuarioPublicoCtrl@index');
		Route::post('store','UsuarioPublicoCtrl@store');
		Route::put('update/{id}','UsuarioPublicoCtrl@update');
		Route::delete('delete/{id}','UsuarioPublicoCtrl@delete');

		Route::get('consulta','UsuarioPublicoCtrl@consultaRegistros');
	});

	Route::group(['prefix' => 'parametro'],function ()
	{
		Route::get('','ParametroCtrl@index');
		Route::put('update/{id}','ParametroCtrl@update');

		Route::get('carta','ParametroCtrl@carta');
		Route::get('carta_numero','ParametroCtrl@cartaNumero');
		Route::get('manifiesto','ParametroCtrl@manifiesto');
		Route::get('manifiesto_numero','ParametroCtrl@manifiestoNumero');
	});

	Route::group(['prefix' => 'carta'],function ()
	{
		Route::post('store','CartaCtrl@store');
		Route::post('mago/store','CartaCtrl@magoStore');
		Route::get('seleccionar','CartaCtrl@seleccionarCarta');

		Route::post('imprimir','CartaCtrl@imprimir');

		Route::put('estado/update/{carta_id}','CartaCtrl@updateEstado');
	});

	Route::group(['prefix' => 'manifiesto'],function ()
	{
		Route::post('store','ManifiestoCtrl@store');
		Route::get('seleccionar','ManifiestoCtrl@seleccionarManifiesto');
		Route::post('imprimir','ManifiestoCtrl@imprimir');


		Route::put('estado/update/{carta_id}','ManifiestoCtrl@updateEstado');
	});

	Route::group(['prefix' => 'usuario_app'], function() {
		Route::get('lista', 'TaUsuariosCtrl@list');
		Route::get('parametros','TaUsuariosCtrl@parameters');
		Route::post('store','TaUsuariosCtrl@save');
		Route::put('update/{id}','TaUsuariosCtrl@update');
		Route::delete('delete/{id}','TaUsuariosCtrl@delete');
	});

	Route::group(['prefix' => 'compras'], function() {
		Route::get('lista', 'ComprasCtrl@list');
		Route::get('parametros','ComprasCtrl@parameters');
		Route::get('consu','ComprasCtrl@condocsun');
		Route::post('store','ComprasCtrl@save');
		Route::post('apisu/store','ComprasCtrl@savetwo');
		//Route::put('update/{id}','TaUsuariosCtrl@update');
		Route::delete('delete/{id}','ComprasCtrl@delete');
	});


	Route::group(['prefix' => 'ventas'], function() {
		Route::get('lista', 'VentasCtrl@list');
		Route::get('getfact', 'VentasCtrl@getfact');
		Route::get('parametros','VentasCtrl@parameters');
		Route::put('update/{id}','VentasCtrl@update');
		Route::delete('delete/{id}','VentasCtrl@delete');
		Route::get('listaretenciones', 'VentasCtrl@listretenciones');
	});

	Route::group(['prefix' => 'ventaconsulta'], function() {
		Route::get('lista', 'VentaconsultaCtrl@list');
		Route::delete('delete/{id}','VentaconsultaCtrl@bajafact');
	});


	Route::group(['prefix' => 'detraccion'], function() {
		Route::delete('delete/{id}','VentasCtrl@deletetwo');
		Route::post('store','VentasCtrl@saveDetracciones');
	});


	Route::group(['prefix' => 'Guiatrans'], function() {
		Route::get('lista', 'GuiatransCtrl@list');
		Route::get('listaventas', 'GuiatransCtrl@listventas');
		Route::get('buscarventa/{search}', 'GuiatransCtrl@buscarventa');

		Route::get('upestatus/{search}', 'GuiatransCtrl@upestatus');

		Route::put('update/{id}','GuiatransCtrl@update');
		//--//
		Route::get('listaall', 'GuiatransCtrl@listall');
		Route::delete('delete/{id}','GuiatransCtrl@delete');
		//--//
		Route::get('getguia', 'GuiatransCtrl@getguia');
		//Route::get('parametros','GuiatransCtrl@parameters');
		//Route::get('consu','ComprasCtrl@condocsun');
		//Route::post('store','ComprasCtrl@save');
		//Route::post('apisu/store','ComprasCtrl@savetwo');
		//Route::delete('delete/{id}','ComprasCtrl@delete');
	});

	
	Route::group(['prefix' => 'CertificadoVehiculo'], function() {
		Route::get('lista', 'CertificadoVehiculoCtrl@list');
		Route::get('parametros','CertificadoVehiculoCtrl@parameters');
		Route::post('store','CertificadoVehiculoCtrl@save');
		Route::put('update/{id}','CertificadoVehiculoCtrl@update');
		Route::delete('delete/{id}','CertificadoVehiculoCtrl@delete');
	});

	Route::group(['prefix' => 'CertificadoChofer'], function() {
		Route::get('lista', 'CertificadoChoferCtrl@list');
		Route::get('parametros','CertificadoChoferCtrl@parameters');
		Route::post('store','CertificadoChoferCtrl@save');
		Route::put('update/{id}','CertificadoChoferCtrl@update');
		Route::delete('delete/{id}','CertificadoChoferCtrl@delete');
		
	});

	Route::group(['prefix' => 'Clientes'], function() {
		Route::get('lista', 'ClientesCtrl@list');
		Route::get('parametros','ClientesCtrl@parameters');
		Route::post('store','ClientesCtrl@save');
		Route::put('update/{id}','ClientesCtrl@update');
		Route::delete('delete/{id}','ClientesCtrl@delete');
		
	});
	
	Route::group(['prefix' => 'Rutas'], function() {
		Route::get('lista', 'RutasCtrl@list');
		Route::post('store','RutasCtrl@save');
		Route::put('update/{id}','RutasCtrl@update');
		Route::delete('delete/{id}','RutasCtrl@delete');
		
	});

	Route::group(['prefix' => 'Tgastos'], function() {
		Route::get('lista', 'TgastosCtrl@list');
		Route::post('store','TgastosCtrl@save');
		//Route::put('update/{id}','TgastosCtrl@update');
		Route::delete('delete/{id}','TgastosCtrl@delete');
		
	});

	Route::group(['prefix' => 'Tcargadoc'], function() {
		Route::get('lista', 'TcargadocCtrl@list');
		Route::post('store','TcargadocCtrl@save');
		//Route::put('update/{id}','TcargadocCtrl@update');
		Route::delete('delete/{id}','TcargadocCtrl@delete');
		
	});


	Route::group(['prefix' => 'Programacionviaje'], function() {
		Route::get('lista', 'ProgramacionviajeCtrl@list');
		Route::get('parametros','ProgramacionviajeCtrl@parameters');
		Route::post('store','ProgramacionviajeCtrl@save');
		Route::put('update/{id}','ProgramacionviajeCtrl@update');
		Route::delete('delete/{id}','ProgramacionviajeCtrl@delete');
		Route::get('detalle/{id_programacion}', 'ProgramacionviajeCtrl@listdetalle');	
		Route::post('detalle/store','ProgramacionviajeCtrl@guardardetalle');	
	});

	

	Route::group(['prefix' => 'Gesguia'], function() {
		Route::get('lista', 'GuiaCtrl@list');
		Route::get('parametros','GuiaCtrl@parameters');
		Route::post('store','GuiaCtrl@save');
		//Route::put('update/{id}','TcargadocCtrl@update');
		//Route::delete('delete/{id}','TcargadocCtrl@delete');	
	});

	Route::group(['prefix' => 'Pa'],function (){
		Route::post('prueba/store', 'PaCtrl@prueba');
	});


	Route::group(['prefix' => 'rendicion'],function ()
	{
		Route::post('imprimir','RendicionCtrl@imprimir');
	});

});