<!DOCTYPE html>
<html lang="en">
<head>
	<meta charset="UTF-8">
	<title>Document</title>
	<link href="{{ asset('css/grid.css') }}" rel="stylesheet">
	<style>
		.table{
			border: solid 2px black;
			width: 700px;
			font-size: 12px;
			font-family: Calibri;
			page-break-inside: avoid;
		}
		td{
			padding-left: 5px;
			padding-right: 5px;
			padding-top: 2px;
			padding-bottom: 2px;
		}
		.border-bottom{
			border-bottom: solid 1px black;
		}
		.border-top{
			border-top: solid 1px black;
		}
		.border-left{
			border-left: solid 1px black;
		}
		.border-right{
			border-right: solid 1px black;
		}
		.text-center{
			text-align: center;
		}
		.text-right{
			text-align: right;
		}
		strong{
			font-size: 12px;
		}
		.td-no-padding td{
			padding: 0px;
		}
		.no-padding{
			padding: 0px;
		}
		.d-block{
			display: block;
		}
		.row-center{
			display: block;
			text-align: center;
		}
		.v-top{
			vertical-align: top;
		}
	</style>
</head>
<body>
	<table width="700px;" class="table">
		<tr>
			<td rowspan="2" style="text-align: center;padding: 0px;height: 60px;width: 320px;vertical-align: bottom;" class="border-right">
				<img src="{{asset('images/logo.png')}}" alt="" height="40px" width="80px">
				<br>
				<strong>COMUNIDAD ANDINA</strong>
			</td>
			<td style="font-weight: bold;text-align: center;width: 320px;" class="border-bottom">
				Manifiesto de Carga Internacional (MCI)
			</td>
		</tr>
		<tr style="width: 350px;">
			<td>
				<table style="width: 100%;">
					<tr style="font-size: 18px;font-weight: bold;color: red;">
						<td colspan="1">
							N°
						</td>
						<td colspan="4" style="text-align: center;">
							{{$manifiesto->numero_desc}}
						</td>
					</tr>
				</table>
			</td>
		</tr>
		<tr>
			<td colspan="2" class="text-center border-top border-bottom">
				<strong>IDENTIFICACIÓN DEL TRANSPORTISTA AUTORIZADO</strong>
			</td>
		</tr>
		<tr>
			<td style="width: 320px;padding: 0px;" class="border-right v-top">
				<small><strong>1</strong> Denominación o razon social del transportista autorizado</small>
				<br>
				<img src="{{asset('images/logo_trans_carr.png')}}" alt="" height="100px" width="345px">
			</td>
			<td class="v-top" style="padding: 0px;width: 320px;">
				<table>
					<tr>
						<td class="border-bottom" style="width: 320px;"> 
							<small><strong>2</strong> Permiso Originario N° </small>
						</td>		
					</tr>
					<tr>
						<td class="text-center border-bottom" style="width: 320px;">
							<strong>{{$manifiesto->certificado_idoneidad}}</strong>			
						</td>
					</tr>
					
				</table>
			</td>
		</tr>	
		<tr>
			<td colspan="2" class="text-center border-top border-bottom">
				<strong>IDENTIFICACIÓN DEL VEHICULO HABILITADO (CAMIÓN O TRACTO CAMIÓN)</strong>
			</td>
		</tr>
		<tr>
			<td style="padding: 0px;width: 320px;">
				<table>
					<tr>
						<td style="padding: 0px;width: 170px;" class="border-right v-top">
							<small><strong>4</strong> Marca</small>
							<br>
							<strong class="row-center">{{ $manifiesto->vehiculo->marca }}</strong>
						</td>
						<td style="padding: 0px;width: 170px;" class="border-right v-top">
							<small><strong>5</strong> Año de Fabricación</small>
							<br>
							<strong class="row-center">{{ $manifiesto->vehiculo->anio }}</strong>
						</td>
					</tr>
				</table>
			</td>
			<td style="padding: 0px;width: 320px;">
				<table>
					<tr>
						<td style="padding: 0px;width: 170px;" class="border-right v-top">
							<small><strong>6</strong> Placa y País</small>
							<br>
							<strong class="row-center">
								{{ $manifiesto->vehiculo->placa }} - {{ $manifiesto->vehiculo->pais->nombre }}
							</strong>
						</td>
						<td style="padding: 0px;width: 170px;" class="v-top">
							<small><strong>7</strong> Número o serie del chasis</small>
							<br>
							<strong class="row-center">{{ $manifiesto->vehiculo->chasis }}</strong>
						</td>
					</tr>
				</table>
			</td>
		</tr>
		<tr>
			<td style="padding: 0px;width: 320px;" class="border-top border-right">
				<small><strong>8</strong> Certificado de Habilitacion N°</small>
				<br>
				<strong class="row-center">{{ $manifiesto->vehiculo->certificado_habilitacion }}</strong>
			</td>
			<td style="padding: 0px;width: 320px;" class="border-top">
			</td>
		</tr>		
		<tr>
			<td colspan="2" class="text-center border-top border-bottom">
				<strong>IDENTIFICACIÓN DE LA UNIDAD DE CARGA (REMOLQUE O SEMI-REMOLQUE)</strong>
			</td>
		</tr>
		<tr>
			<td style="padding: 0px;width: 320px;">
				<table>
					<tr>
						<td style="padding: 0px;width: 170px;" class="border-right v-top">
							<small><strong>9</strong> Marca</small>
							<br>
							@if($manifiesto->remolque_id)
								<strong class="row-center">{{ $manifiesto->remolque->marca }}</strong>
							@else
								<br>
							@endif
						</td>
						<td style="padding: 0px;width: 170px;" class="border-right v-top">
							<small><strong>10</strong> Año de Fabricación</small>
							<br>
							@if($manifiesto->remolque_id)
								<strong class="row-center">{{ $manifiesto->remolque->anio }}</strong>
							@else
								<br>
							@endif
						</td>
					</tr>
				</table>
			</td>
			<td style="padding: 0px;width: 320px;">
				<table>
					<tr>
						<td style="padding: 0px;width: 170px;" class="border-right v-top">
							<small><strong>11</strong> Placa y País</small>
							<br>
							@if($manifiesto->remolque_id)
								<strong class="row-center">
									{{ $manifiesto->remolque->placa }} - {{ $manifiesto->remolque->pais->nombre }}
								</strong>
							@else
								<br>
							@endif
						</td>
						<td style="padding: 0px;width: 170px;" class="v-top">
							<small><strong>12</strong> N° chasis</small>
							<br>
							@if($manifiesto->remolque_id)
								<strong class="row-center">{{ $manifiesto->remolque->chasis }}</strong>
							@else
								<br>
							@endif
						</td>
					</tr>
				</table>
			</td>
		</tr>
		<tr>
			<td colspan="2" class="text-center border-top border-bottom">
				<strong>IDENTIFICACIÓN DE LA TRIPULACIÓN</strong>
			</td>
		</tr>
		<tr>
			<td style="padding: 0px;width: 320px;" class="border-right border-bottom">
				<small><strong>13</strong> Conductor principal:</small>
				<br>
				<strong class="row-center">{{ $manifiesto->choferPrincipal->nombres }}</strong>
			</td>
			<td style="padding: 0px;width: 320px;" class="border-bottom v-top">
				<small><strong>18</strong> Conductor Auxiliar: Nombres y apellidos</small>
				<br>
				<strong class="row-center">
					{{ ($manifiesto->choferAuxiliar) ? $manifiesto->choferAuxiliar->nombres : '' }}
				</strong>
			</td>
		</tr>
		<tr>
			<td style="padding: 0px;width: 320px;">
				<table>
					<tr>
						<td style="padding: 0px;width: 170px;height: 30px;" class="border-right border-bottom">
							<small><strong>14</strong> Documento de Identidad</small>
							<br>
							<strong class="row-center">{{ $manifiesto->choferPrincipal->documento_identidad }}</strong>
						</td>
						<td style="padding: 0px;width: 170px;height: 30px;" class="border-right border-bottom">
							<small><strong>15</strong> Nacionalidad</small>
							<br>
							<strong class="row-center">{{ $manifiesto->choferPrincipal->nacionalidad }}</strong>
						</td>
					</tr>
				</table>
			</td>
			<td style="padding: 0px;width: 320px;">
				<table>
					<tr>
						<td style="padding: 0px;width: 170px;height: 30px;" class="border-right border-bottom v-top">
							<small><strong>19</strong> Documento de Identidad</small>
							<br>
							<strong class="row-center">
								{{ ($manifiesto->choferAuxiliar) ? $manifiesto->choferAuxiliar->documento_identidad : '' }}
							</strong>
						</td>
						<td style="padding: 0px;width: 170px;height: 30px;" class="border-bottom v-top">
							<small><strong>20</strong> Nacionalidad</small>
							<br>
							<strong class="row-center">
								{{ ($manifiesto->choferAuxiliar) ? $manifiesto->choferAuxiliar->nacionalidad : '' }}
							</strong>
						</td>
					</tr>
				</table>
			</td>
		</tr>
		<tr>
			<td style="padding: 0px;width: 320px;" class="v-top">
				<table>
					<tr>
						<td style="padding: 0px;width: 170px;" class="border-right v-top">
							<small><strong>16</strong> Licencia de Conducir N°</small>
							<br>
							<strong class="row-center">{{ $manifiesto->choferPrincipal->licencia }}</strong>
						</td>
						<td style="padding: 0px;width: 170px;" class="border-right v-top">
							<small><strong>17</strong> Libreta de tripulante terrestre</small>
							<br>
							<strong class="row-center">{{ $manifiesto->choferPrincipal->libreta }}</strong>
						</td>
					</tr>
				</table>
			</td>
			<td style="padding: 0px;width: 320px;" class="v-top">
				<table>
					<tr>
						<td style="padding: 0px;width: 170px;height: 30px;" class="border-right v-top">
							<small><strong>21</strong> Licencia de Conducir N°</small>
							<br>
							<strong class="row-center">
								{{ ($manifiesto->choferAuxiliar) ? $manifiesto->choferAuxiliar->licencia : '' }}
							</strong>
						</td>
						<td style="padding: 0px;width: 170px;height: 30px;" class="v-top">
							<small><strong>22</strong> Libreta de tripulante terrestre</small>
							<br>
							<strong class="row-center">
								{{ ($manifiesto->choferAuxiliar) ? $manifiesto->choferAuxiliar->libreta : '' }}
							</strong>
						</td>
					</tr>
				</table>
			</td>
		</tr>
		<tr>
			<td colspan="2" class="text-center border-top border-bottom">
				<strong>DATOS SOBRE LA CARGA</strong>
			</td>
		</tr>
		<tr>
			<td style="padding: 0px;width: 320px;" class="border-right border-bottom">
				<small><strong>23</strong> Lugar y País de carga</small>
				<br>
				<strong class="row-center">
					{{ $manifiesto->carga_lugar }} - {{ ($manifiesto->cargaPais) ? $manifiesto->cargaPais->nombre : '' }}
				</strong>
			</td>
			<td style="padding: 0px;width: 320px;" class="border-bottom">
				<small><strong>24</strong> Lugar y País de descarga</small>
				<br>
				<strong class="row-center">
					{{ $manifiesto->descarga_lugar }} - {{ ($manifiesto->descargaPais) ? $manifiesto->descargaPais->nombre : '' }}
				</strong>
			</td>
		</tr>
		<tr>
			<td class="border-bottom" style="padding: 0px;" colspan="2">
				<table>
					<tr>
						<td colspan="4" style="padding: 0px;">
							<small><strong>25</strong> Naturaleza de la carga</small>
						</td>
					</tr>
					<tr>
						<td style="width: 120px;padding: 0px;">
							<label for="" style="display: inline-block;">
								A.Peligrosa 
								<input type="checkbox" style="vertical-align: bottom;" {{ ($manifiesto->carga_naturaleza_id == 1) ? "checked" : "" }}>
							</label>
						</td>
						<td style="width: 220px;padding: 0px;">		
							<label for="" style="display: inline-block;">
								B.Sustancias Químicas o precursoras 
								<input type="checkbox" style="vertical-align: bottom;" {{ ($manifiesto->carga_naturaleza_id == 2) ? "checked" : "" }}>
							</label>
						</td>
						<td style="width: 140px;padding: 0px;">		
							<label for="" style="display: inline-block;">
								C.Perecible 
								<input type="checkbox" style="vertical-align: bottom;" {{ ($manifiesto->carga_naturaleza_id == 3) ? "checked" : "" }}>
							</label>
						</td>
						<td style="width: 160px;padding: 0px;">	
							<label for="" style="display: inline-block;">
								D.Otra (especificar) 
								<input type="checkbox" style="vertical-align: bottom;" {{ ($manifiesto->carga_naturaleza_id == 4) ? "checked" : "" }}>
							</label>
						</td>
					</tr>
				</table>
			</td>
		</tr>
		<tr>
			<td colspan="2" style="padding: 0px;border-bottom: solid 2px black;">
				<table>
					<tr>
						<td style="padding: 0px;width: 320px;" class="border-right v-top">
							<small>
								<strong>26</strong> Número de identificación de los contenedores y su capacidad (indicar si son de 20 ó 40 pies u otra)
							</small>
							<br>
							<strong class="row-center">{{ $manifiesto->num_iden_contenedor_capacidad }}</strong>
						</td>
						<td style="padding: 0px;width: 320px;" class="v-top">
							<small><strong>27</strong> Número de los precintos aduaneros</small>
							<br>
							<strong class="row-center">{{ $manifiesto->num_precintos_aduaneros }}</strong>
						</td>
					</tr>
				</table>
			</td>
		</tr>
		<tr>
			<td colspan="2" style="padding: 0px;color: black;border-bottom: solid 2px black;">
				<table>
					<tr>
						<td style="padding: 0px;width: 100px;" class="text-center border-right">
							<small>28 Carta de porte N°</small>
						</td>
						<td style="padding: 0px;width: 180px;" class="border-right text-center">
							<small>29 Descripción de las mercancias</small>
						</td>
						<td style="padding: 0px;width: 70px;" class="border-right text-center">
							<small>30 Cantidad de los bultos</small>
						</td>
						<td style="padding: 0px;width: 120px;" class="border-right text-center">
							<small>31 Clase y marca de los bultos</small>
						</td>
						<td style="padding: 0px;width: 120px;" class="border-right text-center v-top" colspan="2">
							<table>
								<tr>
									<td colspan="2" class="text-center border-bottom v-top" style="padding: 0px;width: 120px;">
										<small>32 Peso en kilogramos</small>
										<br><br>
									</td>
								</tr>
								<tr>
									<td class="text-center border-right" style="padding: 0px;width: 60px;">
										<small>BRUTO</small>
									</td>
									<td class="text-center" style="padding: 0px;width: 60px;">
										<small>NETO</small>
									</td>
								</tr>
							</table>
						</td>
						<td style="padding: 0px;width: 70px;" class="text-center">
							<small>33 <small style="font-size: 10px;">Volumen en m3 u otra unidad de medida</small></small>
						</td>
					</tr>
				</table>
			</td>
		</tr>
		
		<tr>
			<td colspan="2" style="padding: 0px;width: 640px;border-bottom: solid 2px black;">
				<table>
					@if($manifiesto->carta_id)
						@foreach($manifiesto->detalles as $detalle)
							<tr>
								<td style="padding: 0px;width: 100px;" class="text-center">
									<small>{{ $manifiesto->carta->numero_desc }}</small>
								</td>
								<td style="padding: 0px;width: 185px;" class="text-center">
									<small>{{ $detalle->descripcion }}</small>
								</td>
								<td style="padding: 0px;width: 70px;" class="text-center">
									<small>{{ $detalle->cantidad_bulto }}</small>
								</td>
								<td style="padding: 0px;width: 125px;" class="text-center">
									<small>{{ $detalle->clase_marca }}</small>
								</td>
								<td style="padding: 0px;width: 70px;" class="text-center">
									<small>{{ number_format($detalle->bruto,2,'.',',') }}</small>
								</td>
								<td style="padding: 0px;width: 70px;" class="text-center">
									<small>{{ number_format($detalle->neto,2,'.',',') }}</small>
								</td>
								<td style="padding: 0px;width: 60px;" class="text-center border-left">
									<small>{{ number_format($detalle->volumen,2,'.',',') }}</small>
								</td>
							</tr>
						@endforeach
					@endif
					<tr>
						<td colspan="4" style="padding: 0px;width: 480px;">
							@if($manifiesto->carta_id)
								<br>
								<small class="row-center">Exportador : {{ $manifiesto->carta->remitente_nombre }}</small>
								<small class="row-center">Importador : {{ $manifiesto->carta->destinatario_nombre }}</small>
								<small class="row-center">BODEGA A DESCARGAR</small>
								<small class="row-center">{{ $manifiesto->carta->bodega_imprime_manifesto }}</small>
							@else
								<br>
								<br>
								<br>
								<strong class="row-center">VEHICULO VACIO</strong>
								<br>
								<br>
								<br>
							@endif
						</td>
						<td colspan="2" style="padding: 0px;width: 140px;"></td>
						<td class="border-left"></td>
					</tr>
					<tr>
						<td colspan="3" style="padding: 0px;width: 355px;">
							<small>34. Precio de las mercancías y tipo de moneda :</small>
							<strong> {{ $manifiesto->precio_mercancias }}  {{ $manifiesto->tipo_moneda }}</strong>
						</td>
						<td style="padding: 0px;width: 125px;">
							<small class="row-center">TOTAL</small>
						</td>
						<td style="padding: 0px;width: 70px;" class="text-center">
							@if($manifiesto->carta_id)
								<small>{{ number_format($manifiesto->detalles->sum('bruto'),2,'.',',')	}}</small>
							@endif
						</td>
						<td style="padding: 0px;width: 70px;" class="text-center">
							@if($manifiesto->carta_id)
								<small>{{ number_format($manifiesto->detalles->sum('neto'),2,'.',',')	}}</small>
							@endif
						</td>
						<td style="padding: 0px;width: 60px;" class="border-left text-center">
							@if($manifiesto->carta_id)
								<small>{{ number_format($manifiesto->detalles->sum('volumen'),2,'.',',')}}</small>
							@endif
						</td>
					</tr>
				</table>
			</td>
		</tr>
		<tr>
			<td colspan="2" style="padding: 0px;width: 640px;" class="border-bottom">
				<table>
					<tr>
						<td style="padding: 0px;width: 350px;" class="border-right v-top">
							<small>35 Observaciones de la aduana de partida</small>
							<br>
							<strong class="row-center">{{ $manifiesto->aduana_observacion }}</strong>
						</td>
						<td style="padding: 0px;width: 145px;" class="border-right v-top">
							<small>37 Aduana(s) de cruce de frontera</small>
							<br>
							<strong class="row-center">{{ $manifiesto->aduana_cruce_frontera }}</strong>
						</td>
						<td style="padding: 0px;width: 145px;" class="v-top">
							<small>38 Aduana de destino</small>
							<br>
							<strong class="row-center">{{ $manifiesto->aduana_destino }}</strong>
						</td>
					</tr>
				</table>
			</td>
		</tr>
		<tr>
			<td style="padding: 0px;width: 320px;" class="v-top">
				<table>
					<tr>
						<td style="padding: 0px;height: 70px;" class="v-top">
							<small>36. Firma y sello de la autoridad que interviene en la aduana de partida</small>
							<br>
							<br>
							<br>
						</td>
					</tr>
					<tr>
						<td class="border-top v-top">
							<small>40. Fecha de emisión</small>
							<br>
							<strong class="row-center">{{ $manifiesto->iso_fecha_emision }}</strong>
						</td>
					</tr>
				</table>
			</td>
			<td style="width: 320px;" class="border-left v-top">
				<small>El suscrito al hacerse cargo de las mercancías, se obliga a cumplir con las disposiciones de las normas que conforman el ordenamiento jurídico de la Comunidad Andina, de </small>
				<br>
				<br>
				<br>
				<small>39. Nombre, Firma y Sello del transportista Autorizado a su representante o agente</small>
			</td>
		</tr>
	</table>
</body>
</html>