<!DOCTYPE html>
<html lang="en">
<head>
	<meta charset="UTF-8">
	<title>Document</title>
	<link href="{{ asset('css/grid.css') }}" rel="stylesheet">
	<style>
		.table{
			border: solid 2px black;
			width: 700px;
			font-size: 12px;
			font-family: Calibri;
			page-break-inside: avoid;
		}
		td{
			padding-left: 5px;
			padding-right: 5px;
			padding-top: 2px;
			padding-bottom: 2px;
		}
		.border-bottom{
			border-bottom: solid 1px black;
		}
		.border-top{
			border-top: solid 1px black;
		}
		.border-left{
			border-left: solid 1px black;
		}
		.border-right{
			border-right: solid 1px black;
		}
		.text-center{
			text-align: center;
		}
		.text-right{
			text-align: right;
		}
		strong{
			font-size: 12px;
		}
		.td-no-padding td{
			padding: 0px;
		}
		.no-padding{
			padding: 0px;
		}
		.d-block{
			display: block;
		}
		.row-center{
			display: block;
			text-align: center;
		}
		.v-top{
			vertical-align: top;
		}
	</style>
</head>
<body>
	<table width="700px;" class="table">
		<tr>
			<td rowspan="2" style="text-align: center;padding: 0px;height: 65px;width: 320px;vertical-align: bottom;" class="border-right">
				<img src="{{asset('images/logo.png')}}" alt="" height="45px" width="100px">
				<br>
				<strong>COMUNIDAD ANDINA</strong>
			</td>
			<td style="font-weight: bold;text-align: center;width: 320px;" class="border-bottom">
				Carta de Porte Internacional por Carretera ( CPIC)
			</td>
		</tr>
		<tr style="width: 350px;">
			<td>
				<table style="width: 100%;">
					<tr style="font-size: 18px;font-weight: bold;color: red;">
						<td colspan="1">
							N°
						</td>
						<td colspan="4" style="text-align: center;">
							{{$carta->numero_desc}}
						</td>
					</tr>
				</table>
			</td>
		</tr>
		<tr>
			<td rowspan="2" style="width: 320px;padding: 0px;" class="border-top v-top">
				<small><strong>1</strong> Denominación o razon social del transportista autorizado</small>
				<br>
				<img src="{{asset('images/logo_trans_carr.png')}}" alt="" height="100px" width="345px">
			</td>
			<td class=" border-top v-top border-left text-center" style="height: 55px;">
				<small><strong>5</strong> Notificar a </small>
				<br><br>
				<strong>{{$carta->notificar_a}}</strong>
			</td>
		</tr>
		<tr>
			<td class="border-top v-top border-left" style="height: 55px;">
				<small><strong>6</strong> Lugar, país y fecha en que el transportista recibe las mercancías</small>
				<br><br>
				<strong class="row-center">
					{{$carta->recepcion_lugar}}-{{ ($carta->recepcionPais) ? $carta->recepcionPais->nombre : '' }} / {{ $carta->iso_recepcion_fecha }}
				</strong>
			</td>
		</tr>
		<tr>
			<td style="width: 320px;" class="border-top">
				<small><strong>2</strong> Nombre y dirección del remitente</small>
				<br>
				<div class="text-center">
					<strong>{{ $carta->remitente_nombre }}</strong>
					<br>
					<small>{{ $carta->remitente_direccion }}</small>
				</div>
			</td>
			<td style="width: 320px;" class="border-top border-left v-top">
				<small><strong>7</strong> Lugar, país y fecha de embarque de las mercancías</small> 
				<br><br>
				<strong class="row-center">
					{{$carta->embarque_lugar}}-{{ ($carta->embarquePais) ? $carta->embarquePais->nombre : '' }} / {{$carta->iso_embarque_fecha}}
				</strong>
			</td>
		</tr>
		<tr>
			<td style="width: 320px;" class="border-top v-top">
				<small><strong>3</strong> Nombre y dirección del destinatario</small>
				<br>
				<div class="text-center">
					<strong>{{ $carta->destinatario_nombre }}</strong>
					<br>
					<small>{{ $carta->destinatario_direccion }}</small>
				</div>
			</td>
			<td style="width: 320px;" class="border-top border-left v-top">
				<small><strong>8</strong> Lugar, país y fecha convenida para la entrega de las mercancías</small>
				<br><br>
				<strong class="row-center">
					{{$carta->entrega_lugar}}-{{ ($carta->entregaPais) ? $carta->entregaPais->nombre : '' }} / {{$carta->iso_entrega_fecha}}
				</strong>
			</td>
		</tr>
		<tr>
			<td style="width: 320px;" class="border-top">
				<small><strong>4</strong> Nombre y dirección del consignatario</small>
				<br>
				<div class="text-center">
					<strong>{{ $carta->consignatario_nombre }}</strong>
					<br>
					<small>{{ $carta->consignatario_direccion }}</small>
				</div>
			</td>
			<td style="width: 320px;" class="border-top border-left v-top">
				<small><strong>9</strong> Condiciones del transporte y condiciones de pago</small>
				<br>
				<strong class="row-center">{{ $carta->condicion_pago }}</strong>
			</td>
		</tr>

		<tr>
			<td style="width: 640px;" colspan="2" class="border-top no-padding">
				<table>
					<tr>
						<td style="width: 100px;" class="text-center no-padding">
							<small><strong>10</strong> Cantidad y clase de los bultos</small>
						</td>
						<td style="width: 100px;" class="border-left text-center no-padding">
							<small><strong>11</strong> Marcas y números de los bultos</small>
						</td>
						<td style="width: 200px;" class="border-left text-center no-padding">
							<small><strong>12</strong> Descripción corriente de la naturaleza</small>
						</td>
						<td style="width: 230px;" class="border-left text-center no-padding">
							<table>
								<tr>
									<td class="text-center border-bottom" colspan="2" style="padding: 0px;">
										<small><strong>13</strong> PESO EN KILOGRAMOS</small>
									</td>
								</tr>
								<tr class="border-top">
									<td class="text-center" style="width: 130px;">
										NETO
									</td>
									<td class="border-left text-center" style="width: 130px;">
										BRUTO
									</td>
								</tr>
							</table>
						</td>
					</tr>
				</table>
			</td>
		</tr>

		<tr>
			<td style="width: 640px;padding: 0px;padding: 0px;" colspan="2" class="border-top">
				<table>
					<tr>
						<td style="vertical-align: top;padding: 0px;">
							<table style=";vertical-align: top;">
								@if(count($carta->detalles) > 0 )
									@foreach($carta->detalles as $detalle)
										<tr style="vertical-align: top;">
											<td style="width: 100px;padding: 0px;">
												<small>{{ $detalle->cantidad_bulto }}</small>
											</td>
											<td style="width: 100px;padding: 0px;">
												<small>{{ $detalle->clase_marca }}</small>
											</td>
											<td style="width: 186px;padding: 0px;">
												<small>{{ $detalle->descripcion }}</small>
											</td>
										</tr>
									@endforeach
								@else
									<tr style="vertical-align: top;">
										<td style="width: 100px;padding: 0px;"><small></small></td>
										<td style="width: 100px;padding: 0px;"><small></small></td>
										<td style="width: 186px;padding: 0px;"><small></small></td>
									</tr>
								@endif
							</table>
						</td>
						<td style="padding: 0px;vertical-align: top;width: 288px;" class="border-left">
							<table>
								<tr>
									<td style="text-align: center;height: 30px;">
										<strong>
											{{ number_format($carta->peso_neto,2,'.',',') }}
										</strong>
									</td>
									<td class="border-left" style="text-align: center;height: 30px;">
										<strong>
											{{ number_format($carta->peso_bruto,2,'.',',') }}
										</strong>
									</td>
								</tr>
								<tr>
									<td class="border-top text-center">
										<strong>14</strong> Volumen en metros cúbicos
									</td>
									<td class="border-top border-left text-center">
										<strong>15</strong> Otras unidades de medida
									</td>
								</tr>
								<tr>
									<td class="border-top" style="text-align: center;height: 30px;">
										<span>{{ $carta->peso_volumen }}</span>
									</td>
									<td class="border-top border-left" style="text-align: center;height: 30px;">
										<span>{{ $carta->peso_otras_unidades }}</span>
									</td>
								</tr>
								<tr>
									<td class="border-top text-center" colspan="2">
										<strong>16</strong> Precio de las mercancias (INCOTERMS 1990) y tipo de moneda.
									</td>
								</tr>
								<tr>
									<td class="border-top text-center" colspan="2">
										<strong>{{ $carta->peso_tipo_moneda }}</strong>
									</td>
								</tr>
								<tr>
									<td class="border-top text-center" colspan="2">
										<strong>
											{{number_format($carta->peso_precio_mercancia,2,'.',',')}}
										</strong>
									</td>
								</tr>
							</table>
						</td>
					</tr>
				</table>
			</td>
		</tr>

		<tr>
			<td style="padding: 0px;" colspan="2" class="border-top border-bottom">
				<table>
					<tr>
						<td style="width: 345px;padding: 0px;" colspan="4">
							<strong>17</strong> Gastos a Pagar
						</td>
						<td style="width: 345px;padding: 0px;" colspan="4" class="border-left">
							<strong>21</strong> Instrucciones al transportista
						</td>
					</tr>
					<tr>
						<td style="padding: 0px;" colspan="4" class="border-top">
							<table>
								<tr>
									<td class="no-padding">
										<small>Concepto</small>
									</td>
									<td class="no-padding border-left">
										<small>Monto a cargo Remitente</small>
									</td>
									<td class="no-padding text-center border-left">
										<small>Tipo de Moneda</small>
									</td>
									<td class="no-padding border-left">
										<small>Monto a cargo Destinatario</small>
									</td>
									<td class="no-padding text-center border-left">
										<small>Tipo de moneda</small>
									</td>
								</tr>
								<tr>
									<td class="border-top no-padding">
										<span>Valor del flete</span>
									</td>
									<td class="border-top text-right no-padding border-left">
										<strong>
											{{ 
												number_format($carta->gasto_flete_remitente_cargo,2,'.',',')
											}}
										</strong>
									</td>
									<td class="border-top text-center no-padding border-left">
										<span>{{ $carta->gasto_moneda }}</span>
									</td>
									<td class="border-top text-right no-padding border-left">
										<strong>
											{{ 
												number_format($carta->gasto_flete_destinatario_cargo,2,'.',',') 
											}}
										</strong>
									</td>
									<td class="border-top text-center no-padding border-left">
										<span>{{ $carta->gasto_moneda }}</span>
									</td>
								</tr>
								<tr>
									<td class="no-padding">
										<span>Otros gastos suplementarios</span>
									</td>
									<td class="text-right no-padding border-left">
										<strong>
											{{ 
												number_format($carta->gasto_otro_remitente_cargo,2,'.',',')
											}}
										</strong>
									</td>
									<td class="text-center no-padding border-left">
										<span>{{ $carta->gasto_moneda }}</span>
									</td>
									<td class="text-right no-padding border-left">
										<strong>
											{{
												number_format($carta->gasto_otro_destinatario_cargo,2,'.',',') 
											}}
										</strong>
									</td>
									<td class="text-center no-padding border-left">
										<span>{{ $carta->gasto_moneda }}</span>
									</td>
								</tr>
								<tr>
									<td class="border-top no-padding">
										<span>Total</span>
									</td>
									<td class="border-top text-right no-padding border-left">
										<strong>
											{{ 
												number_format($carta->gasto_total_remitente,2,'.',',')
											}}
										</strong>
									</td>
									<td class="border-top text-center no-padding border-left">
										<span>{{ $carta->gasto_moneda }}</span>
									</td>
									<td class="border-top text-right no-padding border-left">
										<strong>
											{{ 
												number_format($carta->gasto_total_destinatario,2,'.',',') 
											}}
										</strong>
									</td>
									<td class="border-top text-center no-padding border-left">
										<span>{{ $carta->gasto_moneda }}</span>
									</td>
								</tr>
								<tr>
									<td colspan="5" class="border-top no-padding">
										<small><strong>18</strong> Documentos recibidos del remitente</small>
										<br>
										<strong class="row-center">
											{{ 
												$carta->remitente_documentos_recibidos 
											}}
										</strong>
									</td>
								</tr>
							</table>
						</td>
						<td style="padding: 0px;" colspan="4" class="border-top border-left">
							<table>
								<tr>
									<td style="vertical-align: top;width: 320px;height: 65px;" class="text-center">
										<pre>{{ $carta->transportista_instrucciones }}</pre>
									</td>
								</tr>
								<tr>
									<td class="border-top" style="vertical-align: top;width: 320px;height: 65px;">
										<strong>22</strong> Observaciones al transportista
										<br>
										<span class="row-center" style="padding-top: 5px;">
											<pre>{{ $carta->transportista_observaciones }}</pre>
										</span>
									</td>
								</tr>
							</table>
						</td>
					</tr>
				</table>
			</td>
		</tr>
	
		<tr>
			<td colspan="2" style="padding: 0px;">
				<table>
					<tr>
						<td style="width: 320px;" colspan="4" class="v-top">
							<strong>19</strong> Lugar, país y fecha de emisión
							<br>
							<strong class="row-center">
								{{$carta->emision_lugar}}-{{ ($carta->emisionPais) ? $carta->emisionPais->nombre : ''}} / {{$carta->iso_emision_fecha}}
							</strong>
						</td>
						<td style="width: 320px;" colspan="4" class="border-left v-top">
							<strong>23</strong> El suscrito al hacerse cargo de las mercancías, se obliga a cumplir con las disposiciones de las normas que conforman el ordenamiento jurídico de la Comunidad Andina, de 
						</td>
					</tr>
					<tr>
						<td style="width: 320px;height: 80px;vertical-align: top;" colspan="4" class="border-top">
							<strong>20</strong> Nombre y firma del remitente o su representante o agente
						</td>
						<td style="width: 320px;height: 80px;vertical-align: top;" colspan="4" class="border-top border-left">
							<strong>24</strong> Nombre, firma y sello del transportista autorizado o su representante o agente
						</td>
					</tr>
				</table>
			</td>
		</tr>
	</table>
</body>
</html>