<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateManifiestoDetalleTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('manifiesto_detalle', function (Blueprint $table) {
            $table->id();

            $table->unsignedBigInteger('manifiesto_id');
            $table->foreign('manifiesto_id')->references('id')->on('manifiesto');

            $table->string('cantidad_bulto',100);
            $table->string('clase_marca',100);
            $table->text('descripcion')->nullable();
            $table->decimal('bruto',10,2)->nullable();
            $table->decimal('neto',10,2)->nullable();
            $table->decimal('volumen',10,2)->nullable();

            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('manifiesto_detalle');
    }
}
