<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateManifiestoTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('manifiesto', function (Blueprint $table) {
            $table->id();

            $table->unsignedInteger('numero');

            $table->string('certificado_idoneidad',100);
            $table->string('permisos_prestacion_servicios',100);

            $table->unsignedBigInteger('vehiculo_id');
            $table->foreign('vehiculo_id')->references('id')->on('vehiculo');

            $table->unsignedBigInteger('remolque_id');
            $table->foreign('remolque_id')->references('id')->on('remolque');

            $table->unsignedBigInteger('chofer_principal_id');
            $table->foreign('chofer_principal_id')->references('id')->on('chofer');

            $table->unsignedBigInteger('chofer_auxiliar_id')->nullable();
            $table->foreign('chofer_auxiliar_id')->references('id')->on('chofer');

            $table->string('carga_lugar',100)->nullable();
            $table->unsignedBigInteger('carga_pais_id')->nullable();
            $table->foreign('carga_pais_id')->references('id')->on('pais');

            $table->string('descarga_lugar',100)->nullable();
            $table->unsignedBigInteger('descarga_pais_id')->nullable();
            $table->foreign('descarga_pais_id')->references('id')->on('pais');

            $table->unsignedInteger('carga_naturaleza_id')->nullable();
            $table->string('carga_naturaleza',100)->nullable();
            $table->string('num_iden_contenedor_capacidad',100)->nullable();
            $table->string('num_precintos_aduaneros',100)->nullable();

            $table->unsignedBigInteger('carta_id')->nullable();
            $table->foreign('carta_id')->references('id')->on('carta');

            $table->decimal('precio_mercancias',10,2)->nullable();
            $table->string('tipo_moneda',100)->nullable();

            $table->string('aduana_observacion',100)->nullable();
            $table->string('aduana_cruce_frontera',100)->nullable();
            $table->string('aduana_destino',100)->nullable();

            $table->date('fecha_emision');

            $table->timestamps();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('manifiesto');
    }
}
