<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateCartaDetalleTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('carta_detalle', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('carta_id');
            $table->foreign('carta_id')->references('id')->on('carta');

            //¿Cadena o número?
            $table->string('cantidad_bulto',100);
            $table->string('clase_marca',100);
            $table->text('descripcion')->nullable();

            $table->timestamps();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('carta_detalle');
    }
}
