<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateCartaTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('carta', function (Blueprint $table) 
        {
            $table->id();

            $table->unsignedInteger('numero');

            $table->string('remitente_nombre',100);
            $table->string('remitente_direccion',100)->nullable();

            $table->string('destinatario_nombre',100);
            $table->string('destinatario_direccion',100)->nullable();

            $table->string('consignatario_nombre',100)->nullable();
            $table->string('consignatario_direccion',100)->nullable();

            $table->string('notificar_a',100)->nullable();

            $table->string('recepcion_lugar',100)->nullable();
            $table->unsignedBigInteger('recepcion_pais_id')->nullable();
            $table->foreign('recepcion_pais_id')->references('id')->on('pais');
            $table->date('recepcion_fecha')->nullable();

            $table->string('embarque_lugar',100)->nullable();
            $table->unsignedBigInteger('embarque_pais_id')->nullable();
            $table->foreign('embarque_pais_id')->references('id')->on('pais');
            $table->date('embarque_fecha')->nullable();

            $table->string('entrega_lugar',100)->nullable();
            $table->unsignedBigInteger('entrega_pais_id')->nullable();
            $table->foreign('entrega_pais_id')->references('id')->on('pais');
            $table->date('entrega_fecha')->nullable();

            $table->string('condicion_pago',100)->nullable();

            $table->decimal('peso_neto',10,2)->nullable();
            $table->decimal('peso_bruto',10,2)->nullable();
            $table->decimal('peso_volumen',10,2)->nullable();
            $table->decimal('peso_otras_unidades',10,2)->nullable();
            //¿Mantenedor para tipos de monedas?
            $table->string('peso_tipo_moneda',100);
            $table->decimal('peso_precio_mercancia',10,2);

            //¿Cadena o número?
            $table->string('remitente_documentos_recibidos',100)->nullable();

            $table->string('emision_lugar',100)->nullable();
            $table->unsignedBigInteger('emision_pais_id')->nullable();
            $table->foreign('emision_pais_id')->references('id')->on('pais');
            $table->date('emision_fecha')->nullable();

            $table->text('transportista_instrucciones',100)->nullable();
            $table->text('transportista_observaciones',100)->nullable();

            $table->string('bodega_imprime_manifesto',100);

            //Gastos
            $table->string('gasto_moneda',20)->nullable();

            $table->decimal('gasto_flete_remitente_cargo',10,2)->nullable();
            $table->decimal('gasto_flete_destinatario_cargo',10,2)->nullable();

            $table->decimal('gasto_otro_remitente_cargo',10,2)->nullable();
            $table->decimal('gasto_otro_destinatario_cargo',10,2)->nullable();

            $table->timestamps();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('carta');
    }
}
