<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Ventas extends Model
{
	use SoftDeletes;

    protected $table = 'ventas';
    protected $fillable = ['fecha','tipodoc','serie','numero','moneda','ruc','razonsocial','baseimponible','igv','total','tipo_ingreso','usuario_ingreso','flagasociada','id_formapago','fechapago','montopago','detallepago','enabled','iddetraccion','docdetraccion','razdetraccion','fecdetraccion','montodetraccion'];
    protected $primaryKey = 'id';
    /*
    protected $casts = [
    	'enabled' => 'boolean'
    ];
    */
    public function tipodoc() {
        return $this->belongsTo(Tipodoccompra::class,'tipodoc');
    }

    public function formapago() {
        return $this->belongsTo(Formapago::class,'id_formapago');
    }

    
}
