<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Vehiculo extends Model
{
	use SoftDeletes;

    protected $table = 'vehiculo';
    protected $fillable = ['placa','marca','chasis','certificado_habilitacion','anio','pais_id','certsunat','enabled'];

    protected $casts = [
    	'enabled' => 'boolean'
    ];
    
    public function pais()
    {
    	return $this->belongsTo(Pais::class);
    }

    
    public function allowDelete()
    {
        $manifiestos = Manifiesto::where('vehiculo_id',$this->id)->count();

        ///*
        if($manifiestos > 0)
            return [
                'check' => false,
                'fails' => "{$this->placa} no puede ser eliminado porque tiene manifiestos registrados"
            ];
        //*/
        return [
            'check' => true
        ];
    }
    

}
