<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class UsuarioPublico extends Model
{
	use SoftDeletes;

    protected $table = 'usuario_publico';
    protected $fillable = ['nombre','codigo'];

    public function descargas()
    {
        return $this->hasMany(Descarga::class);
    }

    public function allowDelete()
    {
        return [
            'check' => true
        ];
    }
}
