<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class TaUsuarios extends Model
{
	use SoftDeletes;

    protected $table = 'ta_usuarios';
    protected $fillable = ['username','password','pnombre','nivel','id_chofer','id_vehiculo','id_remolque','enabled'];
    protected $primaryKey = 'id_usuario';

    protected $casts = [
    	'enabled' => 'boolean'
    ];
  
    public function vehiculo() {
        return $this->belongsTo(Vehiculo::class,'id_vehiculo');
    }

    public function chofer() {
        return $this->belongsTo(Chofer::class,'id_chofer');
    }

    public function remolque() {
        return $this->belongsTo(Remolque::class,'id_remolque');
    }
}
