<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Programacionviaje extends Model
{
	use SoftDeletes;

    protected $table = 'ta_programacionviaje';
    protected $fillable = ['id_usuario','id_vehiculo','id_remolque','fecha','id_cliente','ruta_origen','ruta_destino','estado','user_crea'];
    protected $primaryKey = 'id_programacion';

    
    public function tausuario() {
        return $this->belongsTo(TaUsuarios::class,'id_usuario');
    }

    public function vehiculo() {
        return $this->belongsTo(Vehiculo::class,'id_vehiculo');
    }

    public function remolque() {
        return $this->belongsTo(Remolque::class,'id_remolque');
    }

    public function cliente() {
        return $this->belongsTo(Clientes::class,'id_cliente');
    }

    public function rutao() {
        return $this->belongsTo(Rutas::class,'ruta_origen');
    }

    public function rutad() {
        return $this->belongsTo(Rutas::class,'ruta_destino');
    }
}
