<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Pais extends Model
{
	use SoftDeletes;

    protected $table = 'pais';
    protected $fillable = ['nombre','abreviatura','nacionalidad'];

    public function choferes()
    {
        return $this->hasMany(Chofer::class);
    }

    public function remolques()
    {
        return $this->hasMany(Remolque::class);
    }

    public function vehiculos()
    {
        return $this->hasMany(Vehiculo::class);
    }

    public function allowDelete()
    {
        $choferes  = Chofer::where('pais_id',$this->id)->count();

        if($choferes > 0 ) return self::notDeleteMessage();

        $vehiculos = Vehiculo::where('pais_id',$this->id)->count();

        if($vehiculos > 0 ) return self::notDeleteMessage();

        $remolques = Remolque::where('pais_id',$this->id)->count();

        if($remolques > 0 ) return self::notDeleteMessage();

        $manifiestos = Manifiesto::where('carga_pais_id',$this->id)->orWhere('descarga_pais_id',$this->id)->count();

        if($manifiestos > 0 ) return self::notDeleteMessage();

        $cartas    = Carta::where('recepcion_pais_id',$this->id)
                        ->orWhere('embarque_pais_id',$this->id)
                        ->orWhere('entrega_pais_id',$this->id)
                        ->orWhere('emision_pais_id',$this->id)
                        ->count();

        if($cartas > 0 ) return self::notDeleteMessage();

        return ['check' => true];
    }

    public function notDeleteMessage()
    {
        return [
            'check' => false,
            'fails' => "{$this->nombre} no puede ser eliminado"
        ];
    }

}
