<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class ManifiestoDetalle extends Model
{
    protected $table = 'manifiesto_detalle';
    protected $fillable = [
    	'cantidad_bulto',
    	'clase_marca',
    	'descripcion',
    	'manifiesto_id',
    	'bruto',
    	'neto',
    	'volumen',
    ];

    protected $casts = [
		'bruto'   => 'float',
		'neto'    => 'float',
		'volumen' => 'float'
    ];

    public function manifiesto()
    {
    	return $this->belongsTo(Manifiesto::class);
    }
}
