<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Carbon\Carbon;

class Manifiesto extends Model
{
    use SoftDeletes;

    protected $table = 'manifiesto';
    protected $fillable = [
		'numero',
		'certificado_idoneidad',
        'permisos_prestacion_servicios',
		'vehiculo_id',
        'remolque_id',
        'chofer_principal_id',
        'chofer_auxiliar_id',
		'carga_lugar',
        'carga_pais_id',
        'descarga_lugar',
        'descarga_pais_id',
        'carga_naturaleza_id',
		'carga_naturaleza',
        'num_iden_contenedor_capacidad',
        'num_precintos_aduaneros',
		'carta_id',
       	'precio_mercancias',
        'tipo_moneda',
        'aduana_observacion',
        'aduana_cruce_frontera',
        'aduana_destino',
        'fecha_emision',
        'public'
    ];

    protected $appends = [
        'numero_desc',
        'iso_fecha_emision',
        'sin_carta',
        'sin_remolque'
    ];

	protected $casts = [
        'precio_mercancias' => 'float',
        'public' => 'boolean',
    ];

    public function vehiculo()
    {
        return $this->belongsTo(Vehiculo::class);
    }

    public function remolque()
    {
        return $this->belongsTo(Remolque::class);
    }

    public function choferPrincipal()
    {
        return $this->belongsTo(Chofer::class,'chofer_principal_id');
    }

    public function choferAuxiliar()
    {
        return $this->belongsTo(Chofer::class,'chofer_auxiliar_id');
    }

    public function cargaPais()
    {
    	return $this->belongsTo(Pais::class,'carga_pais_id');
    }

    public function descargaPais()
    {
    	return $this->belongsTo(Pais::class,'descarga_pais_id');
    }

    public function carta()
    {
        return $this->belongsTo(Carta::class);
    }

    public function detalles()
    {
        return $this->hasMany(ManifiestoDetalle::class);
    }

    /**
     * Appends
     */
    
    public function getNumeroDescAttribute()
    {
        return str_pad($this->numero, 7, '0', STR_PAD_LEFT);
    }

    public function getIsoFechaEmisionAttribute()
    {
        return static::DateFormat($this->fecha_emision);
    }

    public function getSinCartaAttribute()
    {
        return ($this->detalles->count() == 0);
    }

    public function getSinRemolqueAttribute()
    {
        return (is_null($this->remolque_id));
    }

    /**
     * helpers
     */
    
    public static function DateFormat($date)
    {
        if(is_null($date)) return '';
        
        $date_carbon = new Carbon($date);
        $iso_month = $date_carbon->isoFormat('MMMM');
        return "{$date_carbon->day} de {$iso_month} del {$date_carbon->year}";
    }

}
