<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Ventas;
use App\Formapago;

class VentasCtrl extends Controller
{
    public function list() {
        $ventas = Ventas::with('tipodoc')->whereNull('id_formapago')->where('enabled', '1')->orderBy('id','DESC')->get();
        return $ventas;
    }

    public function parameters() {
        $formapago = Formapago::where('enabled', '1')->orderBy('id')->get();
      
        return [
            'formapago' => $formapago
        ];
    }
    
    public function listretenciones() {
        $lisretenciones = Ventas::with('tipodoc')->whereNotNull('iddetraccion')->orderBy('iddetraccion','DESC')->get();
        return $lisretenciones;
    }

    public function getfact() {
        $fact = Ventas::find(Ventas::max('id'));
        $numerosig =  (int)$fact  ->numero+1;
        $flagins=null;
        //Iniciar loop
        $flagvalida=1;
        while ($flagvalida == 1) {
            $resulcon = api_getfactura(strval($numerosig ));
            #console.log($resulcon);
            if (!empty($resulcon)) {
                if ($resulcon['success'] == true) {

                    //Inserta
                    //Seteo variables 
                   // /*
                    $datai = [
                        'fecha' => convertir_fecha($resulcon['data']['comprobante']['fecha_emision']),
                        'tipodoc' =>  1,
                        'serie' =>  'F001',
                        'numero' =>  $resulcon['data']['comprobante']['correlativo'],
                        'moneda' =>  $resulcon['data']['comprobante']['moneda'],
                        'ruc' =>  $resulcon['data']['receptor']['num_doc'],
                        'razonsocial' =>  strtr($resulcon['data']['receptor']['raz_soc'], array("'" => " ", '"' => " ", ',' => " ", ';' => " ", '<' => " ", '>' => " ")),
                        'baseimponible' =>  $resulcon['data']['totales']['valor'],
                        'igv' =>  $resulcon['data']['impuesto']['IGV']['total'],
                        'total'=>  $resulcon['data']['totales']['importe'],
                        'tipo_ingreso' => 'Automatico',
                        'usuario_ingreso'=>  'Automatico'
                    ];
                   // */
                    Ventas::create($datai);
                    $numerosig  = (int)$numerosig +1;
                    $flagins += 1;
                    //$flagvalida = 0;  
           
                }else{
                    $flagvalida = 0;  
                }
            }
        }
        if ($flagins>0){
            return [
                'success' => true,
                'message' => "Se sincronizo con exito, " . $flagins ." facturas"
            ];
        }else{
            return [
                'success' => true,
                'message' => "No facturas guias pendientes de sincronizar" 
            ];
        }
    } 

    public function update($id, Request $request) {

        try
        {
            $rules = [
                'id_formapago' => 'required',
                'montopago' => 'required'
            ];

            $validator = \Validator::make($request->all(),$rules);

            if($validator->fails())
                return ['fails' => $validator->errors()->getMessages()];

            $venta = Ventas::find($id);

            if (is_null($venta)) {
                return [
                    'success' => false,
                    'message' => "venta no existe!"
                ];
            } 

            $venta->update([
                'id_formapago' => $request->get('id_formapago'),
                'fechapago' => $request->get('fechapago'),
                'montopago' => $request->get('montopago'),
                'detallepago' => $request->get('detallepago')
            ]);

            return [
                'success' => true,
                'message' => "Pago registrado correctamente"
            ];
        }
        catch(\Exception $e)
        {
            return [
                'success' => false,
                'message' => 'Ocurrio un error al intentar registrar pago',
                'error'   => $e->getMessage()
            ];
        }
    }

    public function saveDetracciones(Request $request) {
        try
        {
            $detracciones = $request->get("detracciones");
            if ($detracciones[0][0] == 'Tipo de Cuenta' && $detracciones[0][1] == 'Numero de Cuenta' && $detracciones[0][7] == 'Numero de Documento Adquiriente' && $detracciones[0][10] == 'Monto Deposito'){
                $varsum = 0;
                $pos = 0;
                $posfi=count($detracciones);
                $varup=0;
                for ($pos = 1; $pos <= $posfi; $pos++) {
                    //Set variables 
                    $inumero=isset($detracciones[$pos][15]) ? $detracciones[$pos][15] : null;
                    $icons=isset($detracciones[$pos][2]) ? $detracciones[$pos][2] : null;
                    $idocdet=isset($detracciones[$pos][7]) ? $detracciones[$pos][7] : null;
                    $irzdet=isset($detracciones[$pos][8]) ? $detracciones[$pos][8] : null;
                    $ifecpag=isset($detracciones[$pos][9]) ? $detracciones[$pos][9] : null;
                    $imonpag=isset($detracciones[$pos][10]) ? $detracciones[$pos][10] : null;
                    //Busca venta
                    if ($inumero){
                        $venta = Ventas::where('serie', 'F001')->where('numero', $inumero)->whereNull('iddetraccion')->first();
                        if ($venta) {
                            //echo "Correlativo ".$pos ." - ". $inumero;
                            $venta->update([
                                'iddetraccion' => $icons,
                                'docdetraccion' => $idocdet,
                                'razdetraccion' => $irzdet,
                                'fecdetraccion' =>convertir_fecha($ifecpag),
                                'montodetraccion' =>$imonpag
                            ]);
                            $varup++;
                        }
                    }  
                }
                return [
                    'success' => true,
                    'message' => "Documentos procesados:   " . $posfi ."<br>"."Detracciones registradas:   <b>" . $varup."</b>"
                ];    
            }else{
                return [
                    'success' => false,
                    'message' => 'El archivo no tien el formato requerido',
                    'error'   => 'El archivo no tien el formato requerido'
                ];
            }
        }
        catch(\Exception $e)
        {
            return [
                'success' => false,
                'message' => 'Ocurrio un error al momento de importar',
                'error'   => $e->getMessage()
            ];
        }    
       
    }

    public function delete($id) {
        try
        {
            
            $vent = Ventas::find($id);
            if (is_null($vent)) {
                return [
                    'success' => false,
                    'message' => "Factura no existe!"
                ];
            } 

           
            $vent->update([
                'id_formapago' => null,
                'fechapago' => null,
                'montopago' => null,
                'detallepago' =>null
            ]);
        
           
            return [
                'success' => true,
                'message' => "Se elimino el pago"
            ];
        }
        catch(\Exception $e)
        {
            return [
                'success' => false,
                'message' => 'Ocurrio un error al intentar eliminar el pago',
                'error'   => $e->getMessage()
            ];
        }
    }

    public function deletetwo($id) {
        try
        {
            
            $det = Ventas::find($id);
            if (is_null($det)) {
                return [
                    'success' => false,
                    'message' => "Factura no existe!"
                ];
            } 

           
            $det->update([
                'iddetraccion' => null,
                'docdetraccion' => null,
                'razdetraccion' => null,
                'fecdetraccion' =>null,
                'montodetraccion' =>null
            ]);
        
           
            return [
                'success' => true,
                'message' => "Se elimino la detracción"
            ];
        }
        catch(\Exception $e)
        {
            return [
                'success' => false,
                'message' => 'Ocurrio un error al intentar eliminar la detracción',
                'error'   => $e->getMessage()
            ];
        }
    }


}

function api_getfactura($nfact) {
    $url = "https://api.smart-datamen.com/v2/sunat/cpe/20525787100-01-F001-" . $nfact . "/json";
    $headers = array(
        "Authorization: Bearer O4zjLoURZtPsZHyn9bBqrwjSLdaToroypDiEclpb24ebb98c"
    );
    
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
    curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
    
    $response = curl_exec($ch);
    $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    curl_close($ch);
    
    if ($httpCode == 200) {
        return json_decode($response, true);
    } else {
        return [];
    }
}

// Función para convertir el formato de fecha
function convertir_fecha($fecha) {
    $fechaObj = implode("-", array_reverse(explode("/", $fecha)));

    // Verifica si la fecha es válida
    if ($fechaObj) {
        return $fechaObj;
    } else {
        return Null; 
    }
}