<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Ventas;
use App\Formapago;

class VentaconsultaCtrl extends Controller
{
    public function list() {
        $ventas = Ventas::with('tipodoc')->with('formapago')->orderBy('id','DESC')->get();
        return $ventas;
    }

    public function bajafact($id) {
        try
        {
            
            $det = Ventas::find($id);
            if (is_null($det)) {
                return [
                    'success' => false,
                    'message' => "Factura no existe!"
                ];
            } 

           
            $det->update([
                'enabled' => 0
            ]);
        
           
            return [
                'success' => true,
                'message' => "Se dio de baja con exito"
            ];
        }
        catch(\Exception $e)
        {
            return [
                'success' => false,
                'message' => 'Ocurrio un error al intentar dar de baja',
                'error'   => $e->getMessage()
            ];
        }
    }
}