<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Vehiculo;
use DB;

class VehiculoCtrl extends Controller
{
    public function index()
    {
        $vehiculos = Vehiculo::with('pais')->orderBy('enabled','DESC')->orderBy('placa')->get();

        return compact('vehiculos');
    }

    public function store(Request $request)
    {
        try
        {
            $rules = [
                'placa'                    => 'required|unique:vehiculo',
                'marca'                    => 'required',
                'chasis'                   => 'required',
                'certificado_habilitacion' => 'required',
                'anio'                     => 'required',
                'pais_id'                  => 'required'
            ];

            $validator = \Validator::make($request->all(),$rules);

            if($validator->fails())
                return ['fails' => $validator->errors()->getMessages()];

            Vehiculo::create($request->only('placa','marca','chasis','certificado_habilitacion','anio','pais_id','certsunat'));

            return [
                'success' => true,
                'message' => "Vehiculo registrado correctamente"
            ];
        }
        catch(\Exception $e)
        {
            return [
                'success' => false,
                'message' => 'Ocurrio un error al intentar registrar un Vehiculo',
                'error'   => $e->getMessage()
            ];
        }   
    }

    public function update(Request $request,$id)
    {
        try 
        {
            $vehiculo = Vehiculo::find($id);

            if(is_null($vehiculo)) throw new \Exception("Vehiculo no encontrado.");

            $rules = [
                'placa'                    => 'required|unique:vehiculo,placa,'.$vehiculo->id,
                'marca'                    => 'required',
                'chasis'                   => 'required',
                'certificado_habilitacion' => 'required',
                'anio'                     => 'required',
                'pais_id'                  => 'required',
                'enabled'                  => 'required'
            ];
            
            $validator = \Validator::make($request->all(),$rules);

            if($validator->fails()) return ['fails' => $validator->errors()->getMessages()];

            $vehiculo->update($request->only('placa','marca','chasis','certificado_habilitacion','anio','pais_id','certsunat','enabled'));

            return [
                'success' => true,
                'message' => "Vehiculo actualizado correctamente"
            ];

        } 
        catch (\Exception $e) {
            return [
                'success' => false,
                'message' => "Ocurrio un error al intentar actualizar al Vehiculo",
                'error'   => $e->getMessage()
            ];          
        }
    }

    public function delete($id)
    {
        try 
        {
            $vehiculo = Vehiculo::find($id);

            if(is_null($vehiculo)) throw new \Exception("Vehiculo no encontrado, al parecer alguien lo elimino.");

            $allow = $vehiculo->allowDelete();

            if($allow['check'] == false) throw new \Exception($allow['fails']);

            $vehiculo->delete();

            return [
                'success' => true,
                'message' => "Vehiculo eliminado correctamente"
            ];

        } 
        catch (\Exception $e) {
            return [
                'success' => false,
                'message' => $e->getMessage()
            ];          
        }   
    }
}
