<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\{UsuarioPublico,Carta,Manifiesto,Parametro,Descarga};

class UsuarioPublicoCtrl extends Controller
{

    public function consulta($codigo)
    {
       try 
       {
            $usuario = UsuarioPublico::where('codigo',$codigo)->first();

            if(is_null($usuario)) throw new \Exception("Este código no le corresponde a ningún usuario.");

            $manifiestos = Manifiesto::with('cargaPais','descargaPais')->where('public',true)->orderBy('numero')->get();
            $cartas      = Carta::where('public',true)->orderBy('numero')->get();

            $m = $manifiestos->map(function ($manifiesto){
                return $manifiesto->only(['id','numero_desc','carga_lugar','cargaPais','descarga_lugar','descargaPais','created_at']);
            });

            $c = $cartas->map(function ($carta){
                return $carta->only(['id','numero_desc','remitente_nombre','destinatario_nombre','created_at']); 
            });

            return [
                'success'     => true,
                'manifiestos' => $m,
                'cartas'      => $c
            ];    
       } 
       catch (\Exception $e) {
            return [
                'success' => false,
                'message' => $e->getMessage()
            ];      
        }
    }

    public function consultaRegistros()
    {
        $manifiestos = Manifiesto::with('cargaPais','descargaPais')->orderBy('numero')->get();
        $cartas      = Carta::orderBy('numero')->get();

        $m = $manifiestos->map(function ($manifiesto){
            return $manifiesto->only(['id','numero_desc','carga_lugar','cargaPais','descarga_lugar','descargaPais','created_at','public']);
        });

        $c = $cartas->map(function ($carta){
            return $carta->only(['id','numero_desc','remitente_nombre','destinatario_nombre','created_at','public']); 
        });

        return [
            'success'     => true,
            'manifiestos' => $m,
            'cartas'      => $c
        ];    
    }

    public function consultaPdf(Request $request)
    {
        $usuario = UsuarioPublico::where('codigo',$request->codigo)->first();

        if(is_null($usuario)) return [
            'success' => false,
            'message' => "Este código no le corresponde a ningún usuario."
        ];

        $nombre;
        $pdf;
        $condiciones = Parametro::BuscarPorClave('condiciones_generales');

        if($request->model == 'carta'){
            $carta  = Carta::find($request->id);
            $pdf    = \PDF::loadView('pdf.carta',compact('carta','condiciones'));
            $nombre = $carta->numero_desc;
        }

        if($request->model == 'manifiesto'){
            $manifiesto = Manifiesto::find($request->id);
            $pdf        = \PDF::loadView('pdf.manifiesto',compact('manifiesto','condiciones'));
            $nombre     = $manifiesto->numero_desc;
        }

        Descarga::create([
            'usuario_publico_id' => $usuario->id,   
            'archivo_nombre'     => $nombre
        ]);

        return $pdf->download("{$nombre}.pdf"); 
    }

    public function index()
    {
        $usuarios = UsuarioPublico::with('descargas')->orderBy('nombre')->get();
        return compact('usuarios');
    }

    public function store(Request $request)
    {
        try
        {
            $rules = [
                'nombre' => 'required|unique:usuario_publico',
                'codigo' => 'required|unique:usuario_publico',
            ];

            $validator = \Validator::make($request->all(),$rules);

            if($validator->fails()) return ['fails' => $validator->errors()->getMessages()];

            $usuario = UsuarioPublico::create($request->only('nombre','codigo'));

            return [
                'success' => true,
                'message' => "Usuario registrado correctamente"
            ];
        }
        catch(\Exception $e)
        {
            return [
                'success' => false,
                'message' => 'Ocurrio un error al intentar registrar un usuario',
                'error'   => $e->getMessage()
            ];
        }   
    }

    public function update(Request $request,$id)
    {
        try 
        {
            $usuario = UsuarioPublico::find($id);

            if(is_null($usuario)) throw new \Exception("Usuario no encontrado.");

            $rules = [
                'nombre' => 'required|unique:usuario_publico,nombre,'.$usuario->id,
                'codigo' => 'required|unique:usuario_publico,codigo,'.$usuario->id,
            ];
            
            $validator = \Validator::make($request->all(),$rules);

            if($validator->fails())  return ['fails' => $validator->errors()->getMessages()];

            $usuario->update($request->only('nombre','codigo'));

            return [
                'success' => true,
                'message' => "Usuario actualizado correctamente"
            ];

        } 
        catch (\Exception $e) {
            return [
                'success' => false,
                'message' => "Ocurrio un error al intentar actualizar al usuario",
                'error'   => $e->getMessage()
            ];          
        }
    }

    public function delete($id)
    {
        try 
        {
            $usuario = UsuarioPublico::find($id);

            if(is_null($usuario)) throw new \Exception("Usuario no encontrado, al parecer alguien ya elimino a este usuario.");

            $allow = $usuario->allowDelete();

            if($allow['check'] == false) throw new \Exception($allow['fails']);

            $usuario->delete();

            return [
                'success' => true,
                'message' => "Usuario eliminado correctamente"
            ];

        } 
        catch (\Exception $e) {
            return [
                'success' => false,
                'message' => $e->getMessage()
            ];          
        }   
    }
}
