<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\User;
use Auth;

class UsuarioCtrl extends Controller
{
    public function login(Request $request)
    {
    	try 
    	{
    		if(!Auth::Attempt($request->only('email','password')))    throw new \Exception("Credenciales incorrectas");

            $auth = Auth::user();
                
            if($auth->enabled == false)  throw new \Exception("Su cuenta esta suspendida.");

    		return [
				'success' => true,
				'token'   => $auth->api_token,
                'usuario' => [
                    'nombres' => $auth->nombres,
                    'email'   => $auth->email
                ]
    		];
    	} 
    	catch (\Exception $e) 
    	{
    		return [  
                'success' => false,
                'message' => $e->getMessage()
			];	
    	}
    }

    public function auth()
    {
        $usuario = Auth::user();
        return compact('usuario');
    }

    public function storePassword(Request $request)
    {
        try
        {
            $usuario = Auth::user();
            
            if($request->password != $request->password_confirm)    throw new \Exception("Las contraseñas no coinciden");
                
            $new_password = bcrypt($request->password);

            $usuario->update(['password' => $new_password]);

            return [
                'success' => true,
                'message' => "Contraseña actualizada correctamente"
            ];
        }
        catch(\Exception $e)
        {
            return [
                'success' => false,
                'message' => $e->getMessage()
            ];
        }  
    }

    public function index()
    {
        $usuarios = User::orderBy('nombres')->get();

        return compact('usuarios');
    }

    public function store(Request $request)
    {
        try
        {
            $rules = [
                'nombres'  => 'required|unique:users',
                'email'    => 'required|email|unique:users',
                'password' => 'required'
            ];

            $validator = \Validator::make($request->all(),$rules);

            if($validator->fails())
                return ['fails' => $validator->errors()->getMessages()];

            $usuario = new User();
            $usuario->nombres   = $request->nombres;
            $usuario->email     = $request->email;
            $usuario->password  = bcrypt($request['password']);
            $usuario->enabled   = true;
            $usuario->api_token = bcrypt($usuario->password);
            $usuario->save();

            return [
                'success' => true,
                'message' => "Usuario registrado correctamente"
            ];
        }
        catch(\Exception $e)
        {
            return [
                'success' => false,
                'message' => 'Ocurrio un error al intentar registrar un usuario',
                'error'   => $e->getMessage()
            ];
        }   
    }

    public function update(Request $request,$id)
    {
        try 
        {
            $usuario = User::find($id);

            if(is_null($usuario)) throw new \Exception("Usuario no encontrado.");

            $rules = [
                'nombres' => 'required|unique:users,nombres,'.$usuario->id,
                'email'   => 'required|unique:users,email,'.$usuario->id,
                'enabled' => 'nullable',
            ];
            
            $validator = \Validator::make($request->all(),$rules);

            if($validator->fails())
                return ['fails' => $validator->errors()->getMessages()];

            $usuario->update($request->only('nombres','email','enabled'));

            return [
                'success' => true,
                'message' => "Usuario actualizado correctamente"
            ];

        } 
        catch (\Exception $e) {
            return [
                'success' => false,
                'message' => "Ocurrio un error al intentar actualizar al usuario",
                'error'   => $e->getMessage()
            ];          
        }
    }

    public function delete($id)
    {
        try 
        {
            $usuario = User::find($id);

            if(is_null($usuario)) throw new \Exception("Usuario no encontrado, al parecer alguien ya elimino a este usuario.");

            $allow = $usuario->allowDelete();

            if($allow['check'] == false) throw new \Exception($allow['fails']);

            $usuario->delete();

            return [
                'success' => true,
                'message' => "Usuario eliminado correctamente"
            ];

        } 
        catch (\Exception $e) {
            return [
                'success' => false,
                'message' => $e->getMessage()
            ];          
        }   
    }
}
