<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Rutas;
use DB;

class RutasCtrl extends Controller
{
    public function list() {
        $rutas = Rutas::orderBy('descripcion')->get();
        return $rutas;
    }

  
    public function save(Request $request) {

        try
        {
           
            $rules = [
                'descripcion' => 'required'
                
            ];
            

            $validator = \Validator::make($request->all(),$rules);

            if($validator->fails())
                return ['fails' => $validator->errors()->getMessages()];

            Rutas::create($request->all());

            return [
                'success' => true,
                'message' => "Ruta registrada correctamente"
            ];
        }
        catch(\Exception $e)
        {
            return [
                'success' => false,
                'message' => 'Ocurrio un error al intentar registrar una ruta',
                'error'   => $e->getMessage()
            ];
        }
    }

    public function update($id, Request $request) {

        try
        {
            $rules = [
                'descripcion' => 'required'
                
            ];

            $validator = \Validator::make($request->all(),$rules);

            if($validator->fails())
                return ['fails' => $validator->errors()->getMessages()];

            $cliente = Rutas::find($id);

            if (is_null($cliente)) {
                return [
                    'success' => false,
                    'message' => "Ruta no existe!"
                ];
            } 

            $cliente->update([
                'pais' => $request->get('pais'),
                'departamento' => $request->get('departamento'),
                'provincia' => $request->get('provincia'),
                'distrito' => $request->get('distrito'),
                'descripcion' => $request->get('descripcion'),
                'cod_sunat' => $request->get('cod_sunat'),
                'enabled' => $request->get('enabled'),
            ]);

            return [
                'success' => true,
                'message' => "Ruta actualizada correctamente"
            ];
        }
        catch(\Exception $e)
        {
            return [
                'success' => false,
                'message' => 'Ocurrio un error al intentar registrar el ruta',
                'error'   => $e->getMessage()
            ];
        }
    }

    public function delete($id) {
        try
        {
            $rutas = Rutas::find($id);

            if (is_null($rutas)) {
                return [
                    'success' => false,
                    'message' => "Usuario no existe!"
                ];
            } 

           
            $rutas->delete();

            //Cambiar estado a 1
            
            return [
                'success' => true,
                'message' => "Ruta eliminado correctamente"
            ];
        }
        catch(\Exception $e)
        {
            return [
                'success' => false,
                'message' => 'Ocurrio un error al intentar eliminar un usuario',
                'error'   => $e->getMessage()
            ];
        }
    }
    
}