<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Remolque;
use DB;

class RemolqueCtrl extends Controller
{
    public function index()
    {
    	$remolques = Remolque::with('pais')->orderBy('enabled','DESC')->orderBy('placa')->get();

    	return compact('remolques');
    }

    public function store(Request $request)
    {
        try
        {
            $rules = [
                'placa'   => 'required|unique:remolque',
                'marca'   => 'required',
                'chasis'  => 'required',
                'anio'    => 'required',
                'pais_id' => 'required'
            ];

            $validator = \Validator::make($request->all(),$rules);

            if($validator->fails())
                return ['fails' => $validator->errors()->getMessages()];

            Remolque::create($request->only('placa','marca','chasis','anio','pais_id','certsunat'));

            return [
                'success' => true,
                'message' => "Remolque registrado correctamente"
            ];
        }
        catch(\Exception $e)
        {
            return [
                'success' => false,
                'message' => 'Ocurrio un error al intentar registrar un Remolque',
                'error'   => $e->getMessage()
            ];
        }   
    }

    public function update(Request $request,$id)
    {
        try 
        {
            $remolque = Remolque::find($id);

            if(is_null($remolque)) throw new \Exception("Remolque no encontrado.");

            $rules = [
                'placa'   => 'required|unique:remolque,placa,'.$remolque->id,
                'marca'   => 'required',
                'chasis'  => 'required',
                'anio'    => 'required',
                'pais_id' => 'required'
            ];
            
            $validator = \Validator::make($request->all(),$rules);

            if($validator->fails()) return ['fails' => $validator->errors()->getMessages()];

            $remolque->update($request->only('placa','marca','chasis','anio','pais_id','certsunat','enabled'));

            return [
                'success' => true,
                'message' => "Remolque actualizado correctamente"
            ];

        } 
        catch (\Exception $e) {
            return [
                'success' => false,
                'message' => "Ocurrio un error al intentar actualizar al Remolque",
                'error'   => $e->getMessage()
            ];          
        }
    }

    public function delete($id)
    {
        try 
        {
            $remolque = Remolque::find($id);

            if(is_null($remolque)) throw new \Exception("Remolque no encontrado, al parecer alguien lo elimino.");

            $allow = $remolque->allowDelete();

            if($allow['check'] == false) throw new \Exception($allow['fails']);

            $remolque->delete();

            return [
                'success' => true,
                'message' => "Remolque eliminado correctamente"
            ];

        } 
        catch (\Exception $e) {
            return [
                'success' => false,
                'message' => $e->getMessage()
            ];          
        }   
    }
}
