<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Programacionviaje;
use App\TaUsuarios;
use App\Vehiculo;
use App\Clientes;
use App\Rutas;
use App\Taingreso;


class ProgramacionviajeCtrl extends Controller
{
    public function list() {
        $progviaje = Programacionviaje::with('tausuario','vehiculo','remolque','cliente','rutao','rutad')->where('estado','<>','3')->orderBy('id_programacion','DESC')->get();
        return $progviaje;
    }

    public function listdetalle($id_programacion) {
        $detprogviaje = Taingreso::where('id_programacion',$id_programacion)->get();
        return $detprogviaje;
    }

    public function parameters() {
        $TaUsuarios = TaUsuarios::where('enabled', 1)->orderBy('username')->get();
        $Clientes =Clientes::where('enabled', 1)->orderBy('cliente')->get();
        $Rutas =Rutas::where('enabled', 1)->orderBy('descripcion')->get();
        return [
            'TaUsuarios' => $TaUsuarios,
            'Clientes' => $Clientes,
            'Rutas'=>$Rutas
        ];
    }
    
    
    public function save(Request $request) {

        try
        {
            //encuentra placa de vehiculo segun usuario 
            $findusu = TaUsuarios::find($request->get('id_usuario'));


            $rules = [
                'id_cliente' => 'required',
                'ruta_origen' => 'required',
                'ruta_destino' => 'required',
                'id_usuario' => 'required'
            ];

            $datat = [
                'id_cliente' => $request->get('id_cliente'),
                'id_usuario' => $request->get('id_usuario'),
                'ruta_origen' => $request->get('ruta_origen'),
                'ruta_destino' => $request->get('ruta_destino'),
                'estado' => $request->get('estado'),
                'fecha' => $request->get('fecha'),
                'user_crea' => $request->get('user_crea'),
                'id_vehiculo'=> $findusu['id_vehiculo'],
                'id_remolque'=> $findusu['id_remolque'],

            ];

            $validator = \Validator::make($datat,$rules);

            if($validator->fails())
                return ['fails' => $validator->errors()->getMessages()];

                Programacionviaje::create($datat);

            return [
                'success' => true,
                'message' => "Programacion de viaje registrada correctamente"
            ];
        }
        catch(\Exception $e)
        {
            return [
                'success' => false,
                'message' => 'Ocurrio un error al intentar registrar',
                'error'   => $e->getMessage()
            ];
        }
    }
    /*
    public function update($id, Request $request) {

        try
        {
            $rules = [
                'password' => 'required|min:8',
                'id_vehiculo' => 'required'
            ];

            $validator = \Validator::make($request->all(),$rules);

            if($validator->fails())
                return ['fails' => $validator->errors()->getMessages()];

            $usuario = TaUsuarios::find($id);

            if (is_null($usuario)) {
                return [
                    'success' => false,
                    'message' => "Usuario no existe!"
                ];
            } 

            $usuario->update([
                'username' => $request->get('username'),
                'password' => $request->get('password'),
                'pnombre' => $request->get('pnombre'),
                'nivel' => $request->get('nivel'),
                'id_chofer' => $request->get('id_chofer'),
                'id_vehiculo' => $request->get('id_vehiculo'),
                'enabled' => $request->get('enabled'),
            ]);

            return [
                'success' => true,
                'message' => "Usuario actualizado correctamente"
            ];
        }
        catch(\Exception $e)
        {
            return [
                'success' => false,
                'message' => 'Ocurrio un error al intentar registrar el usuario',
                'error'   => $e->getMessage()
            ];
        }
    }
    */
    public function delete($id) {
        try
        {
            $usuario = Programacionviaje::find($id);

            if (is_null($usuario)) {
                return [
                    'success' => false,
                    'message' => "Programacion no existe!"
                ];
            } 

            if ($usuario["estado"] != "0") {
                return [
                    'success' => false,
                    'message' => "No se puede eliminar una programación iniciada!"
                ];
            } 
           
            $usuario->delete();

            //Cambiar estado a 1
            
            return [
                'success' => true,
                'message' => "Programacion eliminado correctamente"
            ];
        }
        catch(\Exception $e)
        {
            return [
                'success' => false,
                'message' => 'Ocurrio un error al intentar eliminar la programacion',
                'error'   => $e->getMessage()
            ];
        }
    }

    public function guardardetalle(Request $request) {
        return $request->all();
    }
    
}

