<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\{Pais,Carta,Manifiesto,Vehiculo,Remolque,Chofer,Parametro};
use App\Helpers\Model\{Moneda,Naturaleza};
use DB;

class ParametroCtrl extends Controller
{
    public function index()
    {
    	$parametros = Parametro::orderBy('clave')->get();

    	return compact('parametros');
    }

    public function update(Request $request,$id)
    {
        try 
        {
            $parametro = Parametro::find($id);

            if(is_null($parametro)) throw new \Exception("Parametro no encontrado.");

            $rules = [
                'valor' => 'required'
            ];
            
            $validator = \Validator::make($request->all(),$rules);

            if($validator->fails()) return ['fails' => $validator->errors()->getMessages()];

            $parametro->update($request->only('valor'));

            return [
                'success' => true,
                'message' => "Parametro actualizado correctamente"
            ];

        } 
        catch (\Exception $e) {
            return [
                'success' => false,
                'message' => "Ocurrio un error al intentar actualizar al Parametro",
                'error'   => $e->getMessage()
            ];          
        }
    }

    public function carta()
    {
        $monedas        = Moneda::all();
        $moneda_default = Moneda::default();
        $paises         = Pais::orderBy('nombre')->get();
        $numero         = Carta::max('numero') + 1;

        return [
            'success'        => true,
            'monedas'        => $monedas,
            'moneda_default' => $moneda_default,
            'paises'         => $paises,
            'numero'         => str_pad($numero, 7, '0', STR_PAD_LEFT)
        ];
    }

    public function cartaNumero()
    {
        $numero = Carta::max('numero') + 1;
        
        return [
            'numero' => str_pad($numero, 7, '0', STR_PAD_LEFT)
        ];
    }

    public function manifiesto()
    {
        $naturalezas = Naturaleza::all();
        $paises      = Pais::orderBy('nombre')->get();
        $vehiculos   = Vehiculo::with('pais')->orderBy('placa')->get();
        $remolques   = Remolque::with('pais')->orderBy('placa')->get();
        $choferes    = Chofer::where('enabled',true)->with('pais')->orderBy('nombres')->get();
        $numero      = Manifiesto::max('numero') + 1;

        $certificado_idoneidad         = "PO-PE-0004-21";
        $permisos_prestacion_servicios = "NO APLICA";

        return [
            'success'                       => true,
            'naturalezas'                   => $naturalezas,
            'paises'                        => $paises,
            'vehiculos'                     => $vehiculos,
            'remolques'                     => $remolques,
            'choferes'                      => $choferes,
            'numero'                        => str_pad($numero, 7, '0', STR_PAD_LEFT),
            'certificado_idoneidad'         => $certificado_idoneidad,
            'permisos_prestacion_servicios' => $permisos_prestacion_servicios
        ];
    }

    public function manifiestoNumero()
    {
        $numero = Manifiesto::max('numero') + 1;
        $certificado_idoneidad         = "PO-PE-0004-21";
        $permisos_prestacion_servicios = "NO APLICA";
        
        return [
            'numero' => str_pad($numero, 7, '0', STR_PAD_LEFT),
            'certificado_idoneidad'         => $certificado_idoneidad,
            'permisos_prestacion_servicios' => $permisos_prestacion_servicios
        ];
    }
}
