<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Pais;
use DB;

class PaisCtrl extends Controller
{
    public function index()
    {
    	$paises = Pais::orderBy('nombre')->get();

    	return compact('paises');
    }

    public function store(Request $request)
    {
        try
        {
            $rules = [
                'nombre'       => 'required|unique:pais',
                'abreviatura'  => 'required|max:3',
                'nacionalidad' => 'required'
            ];

            $validator = \Validator::make($request->all(),$rules);

            if($validator->fails())
                return ['fails' => $validator->errors()->getMessages()];

            Pais::create($request->only('nombre','abreviatura','nacionalidad'));

            return [
                'success' => true,
                'message' => "País registrado correctamente"
            ];
        }
        catch(\Exception $e)
        {
            return [
                'success' => false,
                'message' => 'Ocurrio un error al intentar registrar un País',
                'error'   => $e->getMessage()
            ];
        }   
    }

    public function update(Request $request,$id)
    {
        try 
        {
            $pais = Pais::find($id);

            if(is_null($pais)) throw new \Exception("País no encontrado.");

            $rules = [
                'nombre'       => 'required|unique:pais,nombre,'.$pais->id,
                'abreviatura'  => 'required|max:3',
                'nacionalidad' => 'required'
            ];
            
            $validator = \Validator::make($request->all(),$rules);

            if($validator->fails()) return ['fails' => $validator->errors()->getMessages()];

            $pais->update($request->only('nombre','abreviatura','nacionalidad'));

            return [
                'success' => true,
                'message' => "País actualizado correctamente"
            ];

        } 
        catch (\Exception $e) {
            return [
                'success' => false,
                'message' => "Ocurrio un error al intentar actualizar al País",
                'error'   => $e->getMessage()
            ];          
        }
    }

    public function delete($id)
    {
        try 
        {
            $usuario = Pais::find($id);

            if(is_null($usuario)) throw new \Exception("País no encontrado, al parecer alguien lo elimino.");

            $allow = $usuario->allowDelete();

            if($allow['check'] == false) throw new \Exception($allow['fails']);

            $usuario->delete();

            return [
                'success' => true,
                'message' => "País eliminado correctamente"
            ];

        } 
        catch (\Exception $e) {
            return [
                'success' => false,
                'message' => $e->getMessage()
            ];          
        }   
    }
}
