<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\{Manifiesto,ManifiestoDetalle,Parametro};
use DB;

class ManifiestoCtrl extends Controller
{
    public function store(Request $request)
    {
    	DB::beginTransaction();

    	try
    	{
    		$rules = [
                'numero'                        => 'required',
                'certificado_idoneidad'         => 'required',
                'permisos_prestacion_servicios' => 'nullable',
                
                'vehiculo_id'                   => 'required',
                'remolque_id'                   => 'nullable',
                'chofer_principal_id'           => 'required',
                
                'chofer_auxiliar_id'            => 'nullable',
                'carga_lugar'                   => 'nullable',
                'carga_pais_id'                 => 'nullable',
                'descarga_lugar'                => 'nullable',
                'descarga_pais_id'              => 'nullable',
                'carga_naturaleza'              => 'nullable',
                'num_iden_contenedor_capacidad' => 'nullable',
                'num_precintos_aduaneros'       => 'nullable',
                'carta_id'                      => 'nullable',
                'precio_mercancias'             => 'nullable',
                'tipo_moneda'                   => 'nullable',
                'aduana_observacion'            => 'nullable',
                'aduana_cruce_frontera'         => 'nullable',
                'aduana_destino'                => 'nullable',
                
                'fecha_emision'                 => 'required|date_format:"Y-m-d"'
            ];

            $validator = \Validator::make(
                            $request->only(
                                'numero',
                                'certificado_idoneidad',
                                'permisos_prestacion_servicios',
                                'vehiculo_id',
                                'remolque_id',
                                'chofer_principal_id',
                                'chofer_auxiliar_id',
                                'carga_lugar',
                                'carga_pais_id',
                                'descarga_pais_id',
                                'carga_naturaleza',
                                'num_iden_contenedor_capacidad',
                                'num_precintos_aduaneros',
                                'carta_id',
                                'precio_mercancias',
                                'tipo_moneda',
                                'aduana_observacion',
                                'aduana_cruce_frontera',
                                'aduana_destino',
                                'fecha_emision'
                            ),
                            $rules);

            if($validator->fails())	return ['fails' => $validator->errors()->getMessages()];

            $query = Manifiesto::where('numero',$request->numero);

            if($request->id)
            	$query = $query->whereNotIn('id',[$request->id]);

            $found = $query->first();

            if($found) throw new \Exception("Ya existe un manifiesto con el N° Preimpreso :  {$request->numero}.");

            $message;

            if($request->id)
            {
				$manifiesto = Manifiesto::find($request->id);

	            $manifiesto->update($request->except('api_token','id','carta'));

	            $ids = collect();

                $manifiesto->detalles()->delete();

                if($request->carta_id)
                {
                    if(count($request->detalles) > 0)
                    {
                        foreach ($request->detalles as $detalle) {
                            $detalle['manifiesto_id'] = $manifiesto->id;
                            ManifiestoDetalle::create($detalle);
                        }
                    }else{
                        $manifiesto->carta_id = null;
                        $manifiesto->save();
                    }
                }

	            $message = "Manifiesto actualizado correctamente";
            }
            else
            {
	            $manifiesto = Manifiesto::create($request->all());

                if($request->carta_id)
                {
                    foreach ($request->detalles as $detalle) {
                        $detalle['manifiesto_id'] = $manifiesto->id;
                        ManifiestoDetalle::create($detalle);
                    }
                }	

	            $message = "Manifiesto registrada correctamente";
            }

            DB::commit();

            return [
                'success' => true,
                'message' => $message
            ];
    	}
    	catch(\Exception $e)
    	{
    		DB::rollback();
    		 return [
                'success' => false,
                'message' => $e->getMessage()
            ];
    	}
    }

    public function seleccionarManifiesto()
    {
    	$manifiestos = Manifiesto::take(100)
                        ->with(
                        'choferPrincipal',
                        'choferAuxiliar',
                        'vehiculo',
                        'remolque',
                        'detalles',
                        'cargaPais',
                        'descargaPais',
                        'carta')
                        ->orderBy('id','DESC')
                        ->get();

    	return compact('manifiestos');
    }

    public function imprimir(Request $request)
    {
    	$manifiesto = Manifiesto::find($request->id);

        $condiciones = Parametro::BuscarPorClave('condiciones_generales');

	    $pdf = \PDF::loadView('pdf.manifiesto',compact('manifiesto','condiciones'));

	    return $pdf->download("{$manifiesto->numero_desc}.pdf");	
    }

    public function updateEstado(Request $request,$manifiesto_id)
    {
        try
        {
            $manifiesto = Manifiesto::find($manifiesto_id);

            if(is_null($manifiesto)) throw new \Exception("El manifiesto ya no exite.");

            $manifiesto->public = !$manifiesto->public;
            $manifiesto->save();
            
            return [
                'success' => true,
                'message' => 'Estado modificado correctamente'
            ];
        }
        catch(\Exception $e)
        {
            return [
                'success' => false,
                'message' => $e->getMessage()
            ];  
        }
    }
}
