<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Guiatrans;
use App\Ventas;


class GuiatransCtrl extends Controller
{
    public function list() {
        $guiatrans = Guiatrans::with('venta')->whereNull('id_venta')->where('cod_estado','!=','02')->orderBy('id','DESC')->get();
        return $guiatrans;
    }

    public function listventas() {
        $ventas = Ventas::where('enabled', '1')->where('flagasociada', 0)->orderBy('id','DESC')->get();
        //$ventas = Ventas::where('enabled', '1')->orderBy('id','DESC')->get();
        return $ventas;
    }

    public function buscarventa($search) {
        //$venserch = Ventas::where("numero","LIKE","%". $search)->first();
        $venserch = Ventas::where("numero", str_pad($search,8,"0",STR_PAD_LEFT))->first();
        return $venserch;
    }

   
    public function update(Request $request,$id)
    {
        try 
        {
            $idventa = $request->get('id_venta');

            $guiatrans = Guiatrans::find($id);
            $venta = Ventas::find($idventa);

            if(is_null($guiatrans) Or is_null($venta)) throw new \Exception("Guia transportisa no encontrada, error!");

            $rules = [
                'id_venta' => 'required'
            ];
            
            $validator = \Validator::make($request->all(),$rules);

            if($validator->fails())
                return ['fails' => $validator->errors()->getMessages()];

            $guiatrans->update($request->only('id_venta'));
            
            $venta->update([
                'flagasociada' => 1
            ]);

            return [
                'success' => true,
                'message' => "Documento asociado correctamente"
            ];

        } 
        catch (\Exception $e) {
            return [
                'success' => false,
                'message' => "Ocurrio un error al intentar asociar el documento",
                'error'   => $e->getMessage()
            ];          
        }
    }

    //**Lista ALL */
    public function listall() {
        $guiatrans = Guiatrans::with('venta')->orderBy('id','DESC')->get();
        return $guiatrans;
    }

    public function delete($id) {
        try
        {
            
            $guia = Guiatrans::find($id);
            if (is_null($guia)) {
                return [
                    'success' => false,
                    'message' => "Guia no existe!"
                ];
            } 

            $idventa = $guia->id_venta;
            $venta = Ventas::find($idventa);
            if (is_null($venta)) {
                return [
                    'success' => false,
                    'message' => "No existe vinculo con guia"
                ];
            } 

            $guia->update([
                'id_venta' => null
            ]);
        
            $venta->update([
                'flagasociada' => 0
            ]);
           
            return [
                'success' => true,
                'message' => "Se quieto el vinculo"
            ];
        }
        catch(\Exception $e)
        {
            return [
                'success' => false,
                'message' => 'Ocurrio un error al intentar eliminar el Documento',
                'error'   => $e->getMessage()
            ];
        }
    }

    public function upestatus($id_ven) {

        $guia = Guiatrans::find($id_ven);
        if (is_null($guia)) {
            return [
                'success' => false,
                'message' => "Guia no existe!"
            ];
        }

        $resulcon = api_getguia(strval($guia['nro_guiatrans']));

        if (!empty($resulcon)) {
            if ($resulcon['success'] == true) {
                //Here Go
                $guia->update([
                    'cod_estado' => $resulcon['data']['codEstado'],
                    'des_estado' => $resulcon['data']['desEstado']
                   // 'des_estado' =>'DD'
                ]);


                return [
                    'success' => true,
                    'message' => "Se actualizo el estado"
                ];
            }else{
                return [
                    'success' => true,
                    'message' => "No se encontro la guia1" + $guia['nro_guiatrans']
                ];
            }
        }else{
            return [
                'success' => true,
                'message' => "No se encontro la guia2" + $guia['nro_guiatrans']
            ];
        }
    }


    //**Lista ALL */
    public function getguia() {
        $guia = Guiatrans::find(Guiatrans::max('id'));
        $nguiasig =  (int)$guia ->nro_guiatrans+1;
        $flagins=null;
        //Iniciar loop
        $flagvalida=1;
        while ($flagvalida == 1) {
            $resulcon = api_getguia(strval($nguiasig));
            #console.log($resulcon);
            if (!empty($resulcon)) {
                if ($resulcon['success'] == true) {

                    //Inserta
                    //Seteo variables 
                    $datai = [
                        'ruc_guiatrans' => '20525787100',
                        'serie_guiatrans' => 'EG03',
                        'nro_guiatrans' => $resulcon['data']['numCpe'],
                        'fecha_emision' => substr($resulcon['data']['emision']['fecEmision'], 0, 10),
                        'fecha_traslado' => substr($resulcon['data']['traslado']['fecInicioTraslado'], 0, 10),
                        'partida_direccion' => strtr($resulcon['data']['traslado']['partida']['direccion']['desDireccion'], array("'" => " ", '"' => " ", ',' => " ", ';' => " ", '<' => " ", '>' => " ")),
                        'partida_dep' => $resulcon['data']['traslado']['partida']['direccion']['desDepartamento'],
                        'partida_prov' => $resulcon['data']['traslado']['partida']['direccion']['desProvincia'],
                        'partida_dist' => $resulcon['data']['traslado']['partida']['direccion']['desDistrito'],
                        'llegada_direccion' => strtr($resulcon['data']['traslado']['llegada']['direccion']['desDireccion'],array("'" => " ", '"' => " ", ',' => " ", ';' => " ", '<' => " ", '>' => " ")),
                        'llegada_dep' => $resulcon['data']['traslado']['llegada']['direccion']['desDepartamento'],
                        'llegada_prov' => $resulcon['data']['traslado']['llegada']['direccion']['desProvincia'],
                        'llegada_dist' => $resulcon['data']['traslado']['llegada']['direccion']['desDistrito'],
                        'remitente_ruc' => $resulcon['data']['remitente']['numDocIdentidad'],
                        'remitente_rz' => $resulcon['data']['remitente']['desNombre'],
                        'destinatario_ruc' => $resulcon['data']['receptor']['numDocIdentidad'],
                        'destinatario_rz' => $resulcon['data']['receptor']['desNombre'],
                        'unidad_peso' => $resulcon['data']['traslado']['codUnidadMedidaPb'],
                        'peso' => $resulcon['data']['traslado']['numPesoBruto'],
                        'vehiculoprin_placa' => $resulcon['data']['traslado']['vehiculo'][0]['numPlaca'],
                        'vehiculoprin_ncertificacion' => $resulcon['data']['traslado']['vehiculo'][0]['numTucChv'],
                        'vehiculosec_placa' => isset($resulcon['data']['traslado']['vehiculo'][1]['numPlaca']) ? $resulcon['data']['traslado']['vehiculo'][1]['numPlaca'] : null,
                        'vehiculosec_ncertificacion' => isset($resulcon['data']['traslado']['vehiculo'][1]['numTucChv']) ? $resulcon['data']['traslado']['vehiculo'][1]['numTucChv'] : null,
                        'conductor_dni' => $resulcon['data']['traslado']['conductor'][0]['numDocIdentidad'],
                        'conductor_nombre' => $resulcon['data']['traslado']['conductor'][0]['desNombre'],
                        'conductor_nlicencia' => $resulcon['data']['traslado']['conductor'][0]['numLicencia'],
                        'observacion' => $resulcon['data']['emision']['receptorObs'],
                        'file_attached' => $resulcon['data']['emision']['desQr'],
                        'cod_estado' => $resulcon['data']['codEstado'],
                        'des_estado' => $resulcon['data']['desEstado'],
                        'pagador_codTipoDocIdentidad' => isset($resulcon['data']['traslado']['pagadorFlete']['codTipoDocIdentidad']) ? $resulcon['data']['traslado']['pagadorFlete']['codTipoDocIdentidad'] : null,
                        'pagador_numDocIdentidad' => isset($resulcon['data']['traslado']['pagadorFlete']['numDocIdentidad']) ? $resulcon['data']['traslado']['pagadorFlete']['numDocIdentidad'] : null,
                        'pagador_desNombre' => isset($resulcon['data']['traslado']['pagadorFlete']['desNombre']) ? $resulcon['data']['traslado']['pagadorFlete']['desNombre'] : null
                    ];
                    Guiatrans::create($datai);

                    $nguiasig = (int)$nguiasig+1;
                    $flagins += 1;
           
                }else{
                    $flagvalida = 0;  
                }
            }else{
                #$flagvalida = 0;   
            }
        }
        if ($flagins>0){
            return [
                'success' => true,
                'message' => "Se sincronizo con exito, " . $flagins ." guias"
            ];
        }else{
            return [
                'success' => true,
                'message' => "No existen guias pendientes de sincronizar" 
            ];
        }
    } 
}

//Función para obtener datos de la guía
function api_getguia($nguia) {
    $url = "https://api.smart-datamen.com/v2/sunat/gre/20525787100-31-EG03-" . $nguia;
    $headers = array(
        'Authorization: Bearer O4zjLoURZtPsZHyn9bBqrwjSLdaToroypDiEclpb24ebb98c'
    );

    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
    curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
    $response = curl_exec($ch);
    $httpcode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    curl_close($ch);

    if ($httpcode == 200) {
        return json_decode($response, true);
    } else {
        return [];
    }
}
