<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Clientes;
use App\Tipodoc;
use DB;

class ClientesCtrl extends Controller
{
    public function list() {
        $clientes = Clientes::with('Tipodoc')->get();
        return $clientes;
    }

    public function parameters() {
        $tipodoc = Tipodoc::where('estado', '1')->orderBy('tipo')->get();
      
        return [
            'tipodoc' => $tipodoc
        ];
    }
   
    public function save(Request $request) {

        try
        {
           
            $rules = [
                'tipo_doc' => 'required',
                'documento' => 'required',
                'cliente' => 'required'
                
            ];
            

            $validator = \Validator::make($request->all(),$rules);

            if($validator->fails())
                return ['fails' => $validator->errors()->getMessages()];

            Clientes::create($request->all());

            return [
                'success' => true,
                'message' => "Usuario registrado correctamente"
            ];
        }
        catch(\Exception $e)
        {
            return [
                'success' => false,
                'message' => 'Ocurrio un error al intentar registrar un usuario app',
                'error'   => $e->getMessage()
            ];
        }
    }

    public function update($id, Request $request) {

        try
        {
            $rules = [
                'tipo_doc' => 'required',
                'documento' => 'required',
                'cliente' => 'required'
                
            ];

            $validator = \Validator::make($request->all(),$rules);

            if($validator->fails())
                return ['fails' => $validator->errors()->getMessages()];

            $cliente = Clientes::find($id);

            if (is_null($cliente)) {
                return [
                    'success' => false,
                    'message' => "Cliente no existe!"
                ];
            } 

            $cliente->update([
                'tipo_doc' => $request->get('tipo_doc'),
                'documento' => $request->get('documento'),
                'cliente' => $request->get('cliente'),
                'comentario' => $request->get('comentario'),
                'celular' => $request->get('celular'),
                'email' => $request->get('email'),
                'enabled' => $request->get('enabled'),
            ]);

            return [
                'success' => true,
                'message' => "Cliente actualizado correctamente"
            ];
        }
        catch(\Exception $e)
        {
            return [
                'success' => false,
                'message' => 'Ocurrio un error al intentar registrar el usuario',
                'error'   => $e->getMessage()
            ];
        }
    }

    public function delete($id) {
        try
        {
            $clientes = Clientes::find($id);

            if (is_null($clientes)) {
                return [
                    'success' => false,
                    'message' => "Usuario no existe!"
                ];
            } 

           
            $clientes->delete();

            //Cambiar estado a 1
            
            return [
                'success' => true,
                'message' => "Cliente eliminado correctamente"
            ];
        }
        catch(\Exception $e)
        {
            return [
                'success' => false,
                'message' => 'Ocurrio un error al intentar eliminar un usuario',
                'error'   => $e->getMessage()
            ];
        }
    }
    
}