<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Chofer;
use DB;

class ChoferCtrl extends Controller
{
    public function index()
    {
        $choferes = Chofer::orderBy('enabled','DESC')->orderBy('nombres')->get();

        return compact('choferes');
    }

    public function store(Request $request)
    {
        try
        {
            $rules = [
                'documento_identidad' => 'required|size:8|alpha_num|unique:chofer',
                'nombres'             => 'required|unique:chofer',
                'nombre'              => 'required',
                'apellido'            => 'required',
                'licencia'            => 'required',
                'libreta'             => 'required',
                'pais_id'             => 'required'
            ];

            $validator = \Validator::make($request->all(),$rules);

            if($validator->fails())
                return ['fails' => $validator->errors()->getMessages()];

            Chofer::create($request->only('documento_identidad','nombres','nombre','apellido','licencia','ncelular','libreta','pais_id'));

            return [
                'success' => true,
                'message' => "Chofer registrado correctamente"
            ];
        }
        catch(\Exception $e)
        {
            return [
                'success' => false,
                'message' => 'Ocurrio un error al intentar registrar un Chofer',
                'error'   => $e->getMessage()
            ];
        }   
    }

    public function update(Request $request,$id)
    {
        try 
        {
            $chofer = Chofer::find($id);

            if(is_null($chofer)) throw new \Exception("Chofer no encontrado.");

            $rules = [
                'documento_identidad' => 'required|size:8|alpha_num|unique:chofer,documento_identidad,'.$chofer->id,
                'nombres'             => 'required|unique:chofer,nombres,'.$chofer->id,
                'nombre'              => 'required',
                'apellido'            => 'required',
                'licencia'            => 'required',
                'libreta'             => 'required',
                'pais_id'             => 'required',
                'enabled'             => 'required'
            ];
            
            $validator = \Validator::make($request->all(),$rules);

            if($validator->fails()) return ['fails' => $validator->errors()->getMessages()];

            $chofer->update($request->only('documento_identidad','nombres','nombre','apellido','licencia','ncelular','libreta','pais_id','enabled'));

            return [
                'success' => true,
                'message' => "Chofer actualizado correctamente"
            ];

        } 
        catch (\Exception $e) {
            return [
                'success' => false,
                'message' => "Ocurrio un error al intentar actualizar al Chofer",
                'error'   => $e->getMessage()
            ];          
        }
    }

    public function delete($id)
    {
        try 
        {
            $chofer = Chofer::find($id);

            if(is_null($chofer)) throw new \Exception("Chofer no encontrado, al parecer alguien lo elimino.");

            $allow = $chofer->allowDelete();

            if($allow['check'] == false) throw new \Exception($allow['fails']);

            $chofer->delete();

            return [
                'success' => true,
                'message' => "Chofer eliminado correctamente"
            ];

        } 
        catch (\Exception $e) {
            return [
                'success' => false,
                'message' => $e->getMessage()
            ];          
        }   
    }
}
