<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\CertificadoChofer;
use App\Chofer;
use App\Tipocertificado;

class CertificadoChoferCtrl extends Controller
{
    public function list() {
        $Cerchofer =CertificadoChofer::with('chofer','tipocertificado')->get();
        return $Cerchofer;
    }

    
    public function parameters() {
        $tipcert = Tipocertificado::where('modo', 'C')->orderBy('tipo','asc')->get();
        //$chofer = chofer::all();
        $chofer =chofer::where('enabled', '1')->orderBy('nombres')->get();
        return [
            'tipcert' => $tipcert,
            'chofer' => $chofer
        ];
    }

    
    public function save(Request $request) {
        try
        {
            // Validación
            $query = CertificadoChofer::where('id_chofer',$request->get('id_chofer'))->where('id_tipocertificado',$request->get('id_tipocertificado'))->where('estado',0);
            $found = $query->first();
            if($found) throw new \Exception("Ya existe un certificado activo de este tipo  para el mismo conductor");


            //Base64 to PDF
            $filebase64 = $request->get('archivo');

            if ($filebase64 != null || $filebase64 != ''){
                $var_pdf=1;
                $pdf_name = "CON_".$request->get('id_chofer')."_".round(microtime(true) * 1000).".pdf"; 
                $pdf_upload_dir ="/var/www/html/sisdoc/app_movil/recursos/certificados/".$pdf_name; 
                
                $ruta_mysql="http://www.transcarr.com/sisdoc/app_movil/recursos/certificados/".$pdf_name; 
                //$ruta_mysql="http://157.55.179.51/sisdoc/app_movil/recursos/certificados/".$pdf_name; 
                $flag = file_put_contents($pdf_upload_dir, base64_decode($filebase64 ));

                if (!$flag){
                    return [
                        'success' => false,
                        'message' => "No se adjunto con exito el documento"
                    ];
                }
            }
            else{
                $var_pdf=0;
                $ruta_mysql="";
            }

            $data = [
                    'fecha_emision' => $request->get('fecha_emision'),
                    'fecha_vencimiento' => $request->get('fecha_vencimiento'),
                    'descripcion' => $request->get('descripcion'),
                    'id_tipocertificado' => $request->get('id_tipocertificado'),
                    'id_chofer' => $request->get('id_chofer')
                    ,'estado' => $request->get('estado')
                    ,'documento' =>$ruta_mysql
                     ];

            $rules = [
                    'id_chofer' => 'required',
                    'id_tipocertificado' => 'required'
                    ];
            
            $validator = \Validator::make($data,$rules);
            if($validator->fails())
                return ['fails' => $validator->errors()->getMessages()];

                CertificadoChofer::create($data);

                return [
                    'success' => true,
                    'message' => "Certificado registrado correctamente"
                ];    
        }
        catch(\Exception $e)
        {
            return [
                'success' => false,
                'message' => 'Ocurrio un error: '. $e->getMessage()
                //'error'   => $e->getMessage()
            ];
        }
    }

    
    public function update($id, Request $request) {
        
        try
        {
            $rules = [
                'estado' => 'nullable'
            ];

            $validator = \Validator::make($request->all(),$rules);

            if($validator->fails())
                return ['fails' => $validator->errors()->getMessages()];

      

            $usuario = CertificadoChofer::find($id);

            if ($request->get('estado')== 0) {
                // Validación
                $query = CertificadoChofer::where('id_chofer',$request->get('id_chofer'))->where('id_tipocertificado',$request->get('id_tipocertificado'))->where('estado',0);
                $found = $query->first();
                if($found) throw new \Exception("Ya existe un certificado activo de este tipo  para el mismo conductor");
            }  


            if (is_null($usuario)) {
                return [
                    'success' => false,
                    'message' => "No existe referencia"
                ];
            } 

            $usuario->update([
                'estado' => $request->get('estado')
            ]);

            return [
                'success' => true,
                'message' => "Certificado actualizado correctamente"
            ];
        }
        catch(\Exception $e)
        {
            return [
                'success' => false,
                'message' => 'Ocurrio un error: '.$e->getMessage(),
                'error'   => $e->getMessage()
            ];
        }
        
    }

    
    public function delete($id) {
        try
        {
           
            $usuario = CertificadoChofer::find($id);
            if (is_null($usuario)) {
                return [
                    'success' => false,
                    'message' => "No existe referencia"
                ];
            } 

           
            $usuario->delete();
            //DB::table('certificado_vehiculo')->delete($id);
            //Cambiar estado a 1
            
            return [
                'success' => true,
                'message' => "Certificado eliminado correctamente"
            ];
        }
        catch(\Exception $e)
        {
            return [
                'success' => false,
                'message' => 'Ocurrio un error al intentar eliminar un Certificado: '.$e->getMessage(),
                'error'   => $e->getMessage()
            ];
        }
    }
    
}
