<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\{Carta,CartaDetalle,Parametro};
use DB;

class CartaCtrl extends Controller
{
    public function store(Request $request)
    {
    	DB::beginTransaction();

    	try
    	{
    		if(count($request->detalles) == 0) throw new \Exception("La carta no contiene detalles.");

    		$rules = [
    			'numero'                          => 'required',
				'remitente_nombre'                => 'required',
				'remitente_direccion'             => 'nullable',
				
				'destinatario_nombre'             => 'required',
				'destinatario_direccion'          => 'nullable',
				
				'consignatario_nombre'            => 'nullable',
				'consignatario_direccion'         => 'nullable',
				
				'notificar_a'                     => 'nullable',
				
				'recepcion_lugar'                 => 'required',
				'recepcion_pais_id'               => 'required',
				'recepcion_fecha'                 => 'required',
				
				'embarque_lugar'                  => 'required',
				'embarque_pais_id'                => 'required',
				'embarque_fecha'                  => 'required',
				
				'entrega_lugar'                   => 'nullable',
				'entrega_pais_id'                 => 'nullable',
				'entrega_fecha'                   => 'nullable',
				
				'condicion_pago'                  => 'nullable',
				
				'peso_neto'                       => 'nullable',
				'peso_bruto'                      => 'nullable',
				'peso_volumen'                    => 'nullable',
				'peso_otras_unidades'             => 'nullable',
				'peso_tipo_moneda'                => 'nullable',
				'peso_precio_mercancia'           => 'nullable',
				
				'gasto_moneda'                    => 'nullable',
				'gasto_flete_remitente_cargo'     => 'nullable',
				'gasto_flete_destinatario_cargo'  => 'nullable',
				'gasto_otro_remitente_cargo'      => 'nullable',
				'gasto_otro_destinatario_cargo'   => 'nullable',
				
				'remitente_documentos_recibidos'  => 'nullable',
				
				'emision_lugar'                   => 'required',
				'emision_pais_id'                 => 'required',
				'emision_fecha'                   => 'required',
				
				'transportista_instrucciones'     => 'nullable',
				'transportista_observaciones'     => 'nullable',
				'bodega_imprime_manifesto'        => 'nullable',
            ];

            $validator = \Validator::make($request->all(),$rules);

            if($validator->fails())	return ['fails' => $validator->errors()->getMessages()];

            $query = Carta::where('numero',$request->numero);

            if($request->id)
            	$query = $query->whereNotIn('id',[$request->id]);

            $found = $query->first();

            if($found) throw new \Exception("Ya existe una carta con el N° Preimpreso :  {$request->numero}.");

            $message;

            if($request->id)
            {
				$carta = Carta::find($request->id);

	            $carta->update($request->except('api_token','id'));

	            $ids = collect();

	            foreach ($request['detalles'] as $key => $item) 
	            {
	            	$detalle = $item;

	            	if(isset($detalle['id']))
	            	{
	            		$found_detalle = CartaDetalle::find($detalle['id']);
	            		$found_detalle->update($item);
	            		$ids->push($detalle['id']);
	            	}
	            	else
	            	{
	            		$detalle['carta_id'] = $carta->id;
	            		$new_detalle = CartaDetalle::create($detalle);	
	            		$ids->push($new_detalle->id);
	            	}
	            }	

	            $carta->detalles()->whereNotIn('id',$ids)->delete();

	            $message = "Carta actualizada correctamente";
            }
            else
            {
	            $carta = Carta::create($request->all());

	            foreach ($request['detalles'] as $detalle) 
	            {
	            	$detalle_request = $detalle;
	            	$detalle_request['carta_id'] = $carta->id;

	            	CartaDetalle::create($detalle_request);	
	            }	

	            $message = "Carta registrada correctamente";
            }

            DB::commit();

            return [
                'success' => true,
                'message' => $message
            ];
    	}
    	catch(\Exception $e)
    	{
    		DB::rollback();
    		 return [
                'success' => false,
                'message' => $e->getMessage()
            ];
    	}
    }

    public function magoStore(Request $request)
    {
    	DB::beginTransaction();

    	try
    	{	
    		$carta = Carta::find($request->id);

    		if(is_null($carta))	throw new \Exception("No se encontro la carta.");

    		$max = Carta::max('numero');

    		$carta->numero = $max + 1;
    		
    		$new_carta = $carta->replicate();
    		$new_carta->save();

    		$carta->detalles->each(function ($detalle) use ($new_carta) 
    		{
    			$detalle->carta_id = $new_carta->id;

    			$new_detalle = $detalle->replicate();
    			$new_detalle->save();
    		});

            DB::commit();

            return [
                'success' => true,
                'message' => "Operación realizada correctamente.",
                'carta'   => $carta
            ];
    	}
    	catch(\Exception $e)
    	{
    		DB::rollback();

    		return [
                'success' => false,
                'message' => $e->getMessage()
            ];
    	}
    }

    public function seleccionarCarta()
    {
    	$cartas = Carta::take(100)->with('detalles')->orderBy('id','DESC')->get();

    	return compact('cartas');
    }

    public function imprimir(Request $request)
    {
    	$carta = Carta::find($request->id);

        $condiciones = Parametro::BuscarPorClave('condiciones_generales');

	    $pdf = \PDF::loadView('pdf.carta',compact('carta','condiciones'));

	    return $pdf->download("{$carta->numero_desc}.pdf");	
    }

    public function updateEstado(Request $request,$carta_id)
    {
        try
        {
            $carta = Carta::find($carta_id);

            if(is_null($carta)) throw new \Exception("La carta ya no exite.");

            $carta->public = !$carta->public;
            $carta->save();
            
            return [
                'success' => true,
                'message' => 'Estado modificado correctamente'
            ];
        }
        catch(\Exception $e)
        {
            return [
                'success' => false,
                'message' => $e->getMessage()
            ];  
        }
    }
}
