<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Guiatrans extends Model
{
	use SoftDeletes;

    protected $table = 'guiatrans';
    protected $fillable = ['ruc_guiatrans','serie_guiatrans','nro_guiatrans','fecha_emision','fecha_traslado','partida_direccion','partida_dep','partida_prov','partida_dist','llegada_direccion','llegada_dep','llegada_prov','llegada_dist','remitente_ruc','remitente_rz','destinatario_ruc','destinatario_rz','unidad_peso','peso','vehiculoprin_placa','vehiculoprin_ncertificacion','vehiculosec_placa','vehiculosec_ncertificacion','conductor_dni','conductor_nombre','conductor_nlicencia','observacion','file_attached','id_venta','cod_estado','des_estado','pagador_codTipoDocIdentidad','pagador_numDocIdentidad','pagador_desNombre'];
    protected $primaryKey = 'id';

    protected $casts = [
    	'enabled' => 'boolean'
    ];
    
    public function venta() {
        return $this->belongsTo(Ventas::class,'id_venta');
    }
    
}
