<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Compras extends Model
{
	use SoftDeletes;

    protected $table = 'compras';
    protected $fillable = ['id_tipo','fecha','serie','numero','moneda','ruc','razonsocial','baseimponible','igv','total','tipo_ingreso','usuario_ingreso'];
    protected $primaryKey = 'id';

    protected $casts = [
    	'enabled' => 'boolean'
    ];
       
    public function tipodoccompra() {
        return $this->belongsTo(Tipodoccompra::class,'id_tipo');
    }
    
}
