<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Clientes extends Model
{
	use SoftDeletes;

    protected $table = 'cliente';
    protected $fillable = ['tipo_doc','documento','cliente','comentario','celular','email','enabled'];
    protected $primaryKey = 'id_cliente';

    protected $casts = [
    	'enabled' => 'boolean'
    ];
  
    public function tipodoc() {
        return $this->belongsTo(Tipodoc::class,'tipo_doc');
    }

}
