<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Chofer extends Model
{
	use SoftDeletes;

    protected $table = 'chofer';
    protected $fillable = ['documento_identidad','nombres','nombre','apellido','licencia','ncelular','libreta','enabled','pais_id'];

    protected $casts = [
    	'enabled' => 'boolean'
    ];
    
    protected $appends = ['nacionalidad'];

    public function getNacionalidadAttribute()
    {
    	return $this->pais->nacionalidad;
    }

    public function pais()
    {
    	return $this->belongsTo(Pais::class);
    }

    
    public function allowDelete()
    {
        $manifiestos = Manifiesto::where('chofer_principal_id',$this->id)
                                ->orWhere('chofer_auxiliar_id',$this->id)
                                ->count();
        ///*
        if($manifiestos > 0)
            return [
                'check' => false,
                'fails' => "{$this->nombres} no puede ser eliminado porque tiene manifiestos registrados"
            ];
        //*/
        return [
            'check' => true
        ];
    }
   
}
